/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;

public class FormTextArea
extends FormElement {
    public static final int DEFAULT_ROWS = 10;
    public static final int DEFAULT_COLS = 50;
    public static final String DEFAULT_WRAP = "soft";
    public static final String DEFAULT_VALUE = "";
    private String value;
    private int maxLength = -1;
    private int minLength;
    private int rows;
    private int cols;
    private String wrap;
    private String placeholder = "";

    public FormTextArea(String name, String value, boolean required, int rows, int cols, String wrap) {
        super(name, value, required);
        this.setRows(rows);
        this.setCols(cols);
        this.setWrap(wrap);
        this.setMinLength(0);
    }

    public FormTextArea(String name, String value, boolean required, String wrap) {
        super(name, value, required);
        this.setWrap(wrap);
        this.setMinLength(0);
    }

    public FormTextArea(String name, String value, boolean required, String wrap, Form form) {
        super(name, value, required, form);
        this.setWrap(wrap);
        this.setMinLength(0);
    }

    public FormTextArea(String name, String value, boolean required, int rows, int cols, String wrap, Form form) {
        super(name, value, required, form);
        this.setRows(rows);
        this.setCols(cols);
        this.setWrap(wrap);
        this.setMinLength(0);
    }

    public FormTextArea(String name, boolean required, int rows, int cols, String wrap) {
        this(name, DEFAULT_VALUE, required, rows, cols, wrap);
    }

    public FormTextArea(String name, boolean required, int rows, int cols, String wrap, Form form) {
        this(name, DEFAULT_VALUE, required, rows, cols, wrap, form);
    }

    public FormTextArea(String name, int rows, int cols, String wrap) {
        this(name, DEFAULT_VALUE, false, rows, cols, wrap);
    }

    public FormTextArea(String name, int rows, int cols, String wrap, Form form) {
        this(name, DEFAULT_VALUE, false, rows, cols, wrap, form);
    }

    public FormTextArea(String name, int rows, int cols) {
        this(name, DEFAULT_VALUE, false, rows, cols, DEFAULT_WRAP);
    }

    public FormTextArea(String name, int rows, int cols, Form form) {
        this(name, DEFAULT_VALUE, false, rows, cols, DEFAULT_WRAP, form);
    }

    public FormTextArea(String name) {
        this(name, DEFAULT_VALUE, false, 10, 50, DEFAULT_WRAP);
    }

    public FormTextArea(String name, Form form) {
        this(name, DEFAULT_VALUE, false, 10, 50, DEFAULT_WRAP, form);
    }

    public FormTextArea setRows(int rows) {
        this.rows = rows;
        return this;
    }

    public FormTextArea setCols(int cols) {
        this.cols = cols;
        return this;
    }

    public FormTextArea setWrap(String wrap) {
        this.wrap = wrap;
        return this;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public String getWrap() {
        return this.wrap;
    }

    @Override
    public FormTextArea setValue(String value) {
        if (!this.isReadOnly()) {
            this.value = value;
        }
        return this;
    }

    @Override
    public FormTextArea setValue(Context context) {
        this.setValue(context.query().get(this.getName(), this.value));
        return this;
    }

    protected String getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public String getRenderableValue() {
        return NetworkHelper.escapeStringForHtml(this.getValue());
    }

    @Override
    public String getEscapedValue() {
        return StringHelper.escapeSingleQuotes(this.getValue());
    }

    @Override
    public int getIntegerValue() {
        return 0;
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(300);
        buffer.append("<textarea");
        buffer.append(this.renderClassName());
        buffer.append(" name=\"" + this.getName() + "\"");
        if (this.getRows() >= 0) {
            buffer.append(" rows=\"" + this.getRows() + "\"");
        }
        if (this.getCols() >= 0) {
            buffer.append(" cols=\"" + this.getCols() + "\"");
        }
        buffer.append(this.renderTabIndex());
        buffer.append(this.renderFormEvents());
        if (StringHelper.isNonEmpty(this.getWrap())) {
            buffer.append(" wrap=\"");
            buffer.append(this.getWrap());
            buffer.append('\"');
        }
        if (StringHelper.isNonEmptyTrimmed(this.getPlaceholder())) {
            buffer.append(" placeholder=\"");
            buffer.append(this.getRenderablePlaceholder());
            buffer.append('\"');
        }
        if (this.isRequired() && this.isUsingHTML5Forms() && this.isValidationEnabled()) {
            buffer.append(" required=\"required\"");
        }
        if (this.isAutofocus()) {
            buffer.append(" autofocus=\"autofocus\"");
        }
        buffer.append(this.renderEnabled());
        buffer.append(this.renderReadOnly());
        buffer.append(this.renderId());
        buffer.append(this.renderStyle(cssCode));
        buffer.append('>');
        buffer.append(this.getRenderableValue());
        buffer.append("</textarea>");
        return buffer.toString();
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public FormTextArea setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public String getRenderablePlaceholder() {
        return NetworkHelper.escapeStringForHtml(this.getPlaceholder());
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        String[] macros;
        if (this.isRequired() && this.getStringValue().length() == 0) {
            macros = new String[]{this.getDisplayName()};
            val.setError("gfta-empty-e", macros, "gfta-empty-i", macros, "gfta-empty-l", macros);
        } else if (this.getStringValue().length() < this.getMinLength()) {
            macros = new String[]{this.getDisplayName(), DEFAULT_VALUE + this.getMinLength()};
            val.setError("gfta-short-e", macros, "gfta-short-i", macros, "gfta-short-l", macros);
        }
        int maximumLength = this.getMaxLength();
        if (maximumLength >= 0 && this.getStringValue().length() > maximumLength) {
            String[] macros2 = new String[]{this.getDisplayName(), DEFAULT_VALUE + maximumLength};
            val.setError("gfta-long-e", macros2, "gfta-long-i", macros2, "gfta-long-l", macros2);
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public FormTextArea setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public FormTextArea setMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public int getMinLength() {
        return this.minLength;
    }
}

