/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.StringHelper;
import java.net.MalformedURLException;
import java.net.URL;

public class FormURLField
extends FormTextField {
    public FormURLField(String displayName, String name, String value, boolean required, int length, int maxLength) {
        super(displayName, name, value, required, length, maxLength);
    }

    public FormURLField(String displayName, String name, String value, boolean required, int length, int maxLength, Form form) {
        super(displayName, name, value, required, length, maxLength, form);
    }

    public FormURLField(String name, String value, boolean required, int length, int maxLength) {
        super(name, value, required, length, maxLength);
    }

    public FormURLField(String name, String value, boolean required, int length, int maxLength, Form form) {
        super(name, value, required, length, maxLength, form);
    }

    public FormURLField(String name, String value, boolean required, int length) {
        super(name, value, required, length);
    }

    public FormURLField(String name, String value, boolean required, int length, Form form) {
        super(name, value, required, length, form);
    }

    public FormURLField(String name, boolean required, int length, int maxLength) {
        super(name, required, length, maxLength);
    }

    public FormURLField(String name, boolean required, int length, int maxLength, Form form) {
        super(name, required, length, maxLength, form);
    }

    public FormURLField(String name, boolean required, int length) {
        super(name, required, length);
    }

    public FormURLField(String name, boolean required, int length, Form form) {
        super(name, required, length, form);
    }

    public FormURLField(String name, int length) {
        super(name, length);
    }

    public FormURLField(String name, int length, Form form) {
        super(name, length, form);
    }

    public FormURLField(String name) {
        super(name);
    }

    public FormURLField(String name, Form form) {
        super(name, form);
    }

    @Override
    public int getIntegerValue() {
        return 0;
    }

    @Override
    public FormURLField setValue(String value) {
        super.setValue(value == null ? "" : value.trim());
        return this;
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        super.requiredValidation(val);
        if (!val.isSet() && StringHelper.isNonEmpty(this.getValue())) {
            try {
                URL url = new URL(this.getValue());
                if (StringHelper.isEmptyTrimmed(url.getHost())) {
                    throw new MalformedURLException("No host provided");
                }
            }
            catch (MalformedURLException e) {
                String[] macros = new String[]{this.getDisplayName()};
                val.setError("gfurlf-malformed-e", macros, "gfurlf-malformed-i", macros, "gfurlf-malformed-l", macros);
            }
        }
    }

    @Override
    public String getType() {
        return "url";
    }

    @Override
    protected void addClientSideValidationClasses() {
        this.addClassName("url");
        super.addClientSideValidationClasses();
    }
}

