/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormValidator;
import com.techempower.gemini.messaging.Message;
import com.techempower.gemini.messaging.MessageType;
import com.techempower.js.JavaScriptObject;
import com.techempower.js.ReflectiveVisitorFactory;
import com.techempower.js.VisitorFactory;
import com.techempower.util.StringList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FormValidation
implements JavaScriptObject {
    public static final String COMPONENT_CODE = "fval";
    public static final VisitorFactory<FormValidation> DEFAULT_VISITOR_FACTORY = new ReflectiveVisitorFactory<FormValidation>(FormValidation.class, "error", "jsonErrorType", "errorDescription", "getInstructionString", "errors", "getErrorStringIterator", "instructions", "getInstructionIterator", "elements", "getElementNames");
    private final Form form;
    private final Context context;
    private boolean errors = false;
    private final Map<FormElement, FormSingleValidation> validations;
    private final List<String> valErrors;
    private final List<FormElement> valElements;
    private final List<String> valInstructions;
    private final Map<FormElement, String> inlineInstructions;

    public FormValidation(Form form, Context context) {
        int elementCount = 0;
        if (form != null) {
            elementCount = form.getElementCount();
            if (form.getValidators() != null) {
                elementCount += form.getValidators().size();
            }
        }
        this.form = form;
        this.context = context;
        this.validations = new HashMap<FormElement, FormSingleValidation>(elementCount);
        this.valErrors = new ArrayList<String>(elementCount);
        this.valInstructions = new ArrayList<String>(elementCount);
        this.valElements = new ArrayList<FormElement>(elementCount);
        this.inlineInstructions = new HashMap<FormElement, String>(elementCount);
        this.processForm();
    }

    @Deprecated
    public FormValidation() {
        this.form = null;
        this.context = null;
        this.validations = new HashMap<FormElement, FormSingleValidation>();
        this.valErrors = new ArrayList<String>();
        this.valInstructions = new ArrayList<String>();
        this.valElements = new ArrayList<FormElement>();
        this.inlineInstructions = new HashMap<FormElement, String>();
    }

    protected void processForm() {
        FormSingleValidation validation;
        if (this.form.getValidators() != null) {
            for (FormValidator validator : this.form.getValidators()) {
                validation = new FormSingleValidation();
                validation.setContext(this.context);
                validator.validate(this.getForm(), this.context, validation);
                this.addFormSingleValidation(validation);
            }
        }
        for (FormElement element : this.form.getList()) {
            validation = element.validate(this.context, this);
            this.addFormSingleValidation(validation);
        }
    }

    public Iterator<FormSingleValidation> getValidationIterator() {
        return this.validations.values().iterator();
    }

    public List<FormSingleValidation> getValidations() {
        return new ArrayList<FormSingleValidation>(this.validations.values());
    }

    public Iterator<String> getErrorStringIterator() {
        return this.valErrors.iterator();
    }

    public List<String> getErrorStrings() {
        return new ArrayList<String>(this.valErrors);
    }

    public List<Message> getErrorMessages() {
        ArrayList<Message> messages = new ArrayList<Message>(this.valErrors.size());
        for (String error : this.valErrors) {
            messages.add(new Message(error, MessageType.ERROR));
        }
        return messages;
    }

    public List<String> getInstructions() {
        return this.valInstructions;
    }

    public Iterator<String> getInstructionIterator() {
        return this.valInstructions.iterator();
    }

    public String getInstructionString() {
        StringList toReturn = new StringList(" ");
        for (String instruction : this.valInstructions) {
            toReturn.add(instruction);
        }
        return toReturn.toString();
    }

    public List<String> getElementNames() {
        ArrayList<String> toReturn = new ArrayList<String>(this.valElements.size());
        for (FormElement element : this.valElements) {
            toReturn.add(element.getName());
        }
        return toReturn;
    }

    public List<FormElement> getElements() {
        return this.valElements;
    }

    public Map<FormElement, String> getInlineInstructions() {
        return new HashMap<FormElement, String>(this.inlineInstructions);
    }

    public String getInlineInstructions(FormElement element) {
        String inline = this.inlineInstructions.get(element);
        return inline != null ? inline : "";
    }

    public String getInlineInstructions(FormElement element, String prefix, String suffix) {
        String inline = this.inlineInstructions.get(element);
        return inline != null ? String.valueOf(prefix) + inline + suffix : "";
    }

    public boolean isErrored(FormElement element) {
        return this.valElements.contains(element);
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public boolean isGood() {
        return !this.hasErrors();
    }

    public Form getForm() {
        return this.form;
    }

    public void addFormSingleValidation(FormSingleValidation validation) {
        if (validation != null && validation.isError()) {
            this.errors = true;
            this.validations.put(validation.getElement(), validation);
            if (validation.getErrorString() != null) {
                this.valErrors.add(validation.getErrorString());
            }
            if (validation.getElement() != null) {
                this.valElements.add(validation.getElement());
            }
            if (validation.getInstruction() != null) {
                this.valInstructions.add(validation.getInstruction());
            }
            if (validation.getInline() != null) {
                this.inlineInstructions.put(validation.getElement(), validation.getInline());
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FormValidation [");
        Iterator<String> iter = this.getErrorStringIterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append("; ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String jsonErrorType() {
        return "Validation failure";
    }

    public VisitorFactory<FormValidation> getJsVisitorFactory() {
        return DEFAULT_VISITOR_FACTORY;
    }
}

