/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.collection.ImmutableNamedValues;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormCheckBox;
import com.techempower.gemini.form.FormDateElement;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormFloatField;
import com.techempower.helper.NumberHelper;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FormValues
implements ImmutableNamedValues {
    public final Form form;

    protected FormValues(Form form) {
        this.form = form;
    }

    @Override
    public boolean has(String name) {
        return this.form.getElement(name) != null;
    }

    @Override
    public Set<String> names() {
        List<FormElement> elements = this.form.getList();
        HashSet<String> toReturn = new HashSet<String>(elements.size());
        for (FormElement element : elements) {
            toReturn.add(element.getName());
        }
        return toReturn;
    }

    @Override
    public String get(String name) {
        return this.get(name, null);
    }

    @Override
    public String get(String name, String defaultValue) {
        Object element = this.form.getElement(name);
        if (element != null) {
            return ((FormElement)element).getStringValue();
        }
        return defaultValue;
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        Object element = this.form.getElement(name);
        if (element != null) {
            return NumberHelper.parseInt(((FormElement)element).getStringValue(), defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int getInt(String name, int defaultValue, int minimum, int maximum) {
        return NumberHelper.boundInteger(this.getInt(name, defaultValue), minimum, maximum);
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        Object element = this.form.getElement(name);
        if (element != null) {
            return NumberHelper.parseLong(((FormElement)element).getStringValue(), defaultValue);
        }
        return defaultValue;
    }

    @Override
    public long getLong(String name, long defaultValue, long minimum, long maximum) {
        return NumberHelper.boundLong(this.getLong(name, defaultValue), minimum, maximum);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        Object element = this.form.getElement(name);
        if (element != null && element instanceof FormCheckBox) {
            return ((FormCheckBox)element).isChecked();
        }
        return false;
    }

    public Date getDate(String dateElementName) {
        Object element = this.form.getElement(dateElementName);
        if (element != null && element instanceof FormDateElement) {
            return ((FormDateElement)element).getDateValue();
        }
        return null;
    }

    public float getFloat(String elementName) {
        return this.getFloat(elementName, 0.0f);
    }

    public float getFloat(String elementName, float defaultValue) {
        Object element = this.form.getElement(elementName);
        if (element != null) {
            if (element instanceof FormFloatField) {
                FormFloatField floatElement = (FormFloatField)element;
                return floatElement.getFloatValue();
            }
            try {
                return Float.parseFloat(((FormElement)element).getStringValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

