/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form.validator;

import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormElementProcessor;
import com.techempower.gemini.form.FormElementValidator;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.StringHelper;
import com.techempower.util.UtilityConstants;

public class AlphanumericValidator
implements FormElementValidator,
FormElementProcessor {
    private static final char[] ACCEPTABLE_CHARACTERS = CollectionHelper.arrayMerge(true, UtilityConstants.CHARACTERS_ALPHA_LOWERCASE, UtilityConstants.CHARACTERS_ALPHA_UPPERCASE, UtilityConstants.CHARACTERS_NUMERIC);

    @Deprecated
    public AlphanumericValidator(boolean automaticStripping) {
    }

    public AlphanumericValidator() {
    }

    @Override
    public void process(FormElement element) {
        String sourceValue = element.getStringValue();
        element.setValue(StringHelper.stripArbitraryCharacters(sourceValue, ACCEPTABLE_CHARACTERS));
    }

    @Override
    public void validate(FormElement element, FormSingleValidation val) {
        String sourceValue = element.getStringValue();
        if (!StringHelper.isAllArbitraryCharacters(sourceValue, ACCEPTABLE_CHARACTERS)) {
            val.setRawError(String.valueOf(element.getDisplayName()) + " contains non-alphanumeric characters.", "Please only use letters and numbers in the field named " + element.getDisplayName() + ".", "Please only use letters and numbers in this field.");
        }
    }
}

