/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form.validator;

import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormElementProcessor;
import com.techempower.gemini.form.FormElementValidator;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.StringHelper;

public class ArbitraryCharacterValidator
implements FormElementValidator,
FormElementProcessor {
    private boolean charactersAllowed = true;
    private char[] characters;

    @Deprecated
    public ArbitraryCharacterValidator(boolean automaticStripping, char[] characters, boolean charactersAllowed) {
        this(characters, charactersAllowed);
    }

    public ArbitraryCharacterValidator(char[] characters, boolean charactersAllowed) {
        this.characters = characters;
        this.charactersAllowed = charactersAllowed;
    }

    @Deprecated
    public ArbitraryCharacterValidator(boolean automaticStripping, char[] allowedCharacters) {
        this(allowedCharacters, true);
    }

    public ArbitraryCharacterValidator(char[] allowedCharacters) {
        this(allowedCharacters, true);
    }

    @Override
    public void process(FormElement element) {
        String sourceValue = element.getStringValue();
        if (this.charactersAllowed) {
            element.setValue(StringHelper.stripArbitraryCharacters(sourceValue, this.characters));
        } else {
            element.setValue(StringHelper.stripUnacceptableCharacters(sourceValue, this.characters));
        }
    }

    @Override
    public void validate(FormElement element, FormSingleValidation val) {
        boolean valid;
        String sourceValue = element.getStringValue();
        boolean bl = valid = this.charactersAllowed ? StringHelper.isAllArbitraryCharacters(sourceValue, this.characters) : StringHelper.isAllArbitraryExcluding(sourceValue, this.characters);
        if (!valid) {
            val.setRawError(String.valueOf(element.getDisplayName()) + " contains invalid characters.", "Please only use permitted characters in the field named " + element.getDisplayName() + ".", "Please only use permitted characters in this field.");
        }
    }
}

