/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form.validator;

import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormElementValidator;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.StringHelper;

public class CityValidator
implements FormElementValidator {
    public static final int MINIMUM_LENGTH = 2;
    public static final int MAXIMUM_LENGTH = 50;

    @Override
    public void validate(FormElement element, FormSingleValidation val) {
        String numbers;
        int len;
        String value = element.getStringValue();
        boolean good = false;
        int n = len = value != null ? value.length() : 0;
        if ((len >= 2 || len <= 50) && (numbers = StringHelper.stripNonNumeric(value)).length() == 0) {
            good = true;
        }
        if (!good) {
            this.setStandardError(element, val);
        }
    }

    protected void setStandardError(FormElement element, FormSingleValidation val) {
        val.setRawError(String.valueOf(element.getDisplayName()) + " does not contian a properly-formatted city name", "Please provide a properly-formatted city name in " + element.getDisplayName() + ".", "Please provide a properly-formatted city name in this field.");
    }
}

