/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form.validator;

import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormElementValidator;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.password.PasswordProposal;
import com.techempower.helper.StringHelper;
import java.util.List;
import java.util.Objects;

public class PasswordComplexityValidator
implements FormElementValidator {
    private final String usernameFieldName;
    private final PyxisUser user;
    private final PyxisSecurity security;

    public PasswordComplexityValidator(PyxisSecurity security, PyxisUser user) {
        Objects.requireNonNull(security, "Security reference not provided.");
        Objects.requireNonNull(user, "User reference not provided.");
        this.user = user;
        this.security = security;
        this.usernameFieldName = null;
    }

    public PasswordComplexityValidator(PyxisSecurity security, String usernameFieldName) {
        Objects.requireNonNull(security, "Security reference not provided.");
        Objects.requireNonNull(usernameFieldName, "Username field name not provided.");
        this.user = null;
        this.security = security;
        this.usernameFieldName = usernameFieldName;
    }

    @Override
    public void validate(FormElement element, FormSingleValidation val) {
        String username;
        PasswordProposal proposal;
        List<String> errors;
        String value = element.getStringValue();
        if (StringHelper.isNonEmpty(value) && (errors = this.security.passwordValidate(proposal = new PasswordProposal(value, username = this.user != null ? this.user.getUserUsername() : element.getForm().values().get(this.usernameFieldName), this.user, val.getContext()))).size() > 0) {
            String synopsis = StringHelper.join(" ", errors);
            val.setRawError(synopsis, synopsis, synopsis);
        }
    }
}

