/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.handler;

import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Handler;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;

public abstract class SecureHandler<D extends BasicDispatcher, C extends Context>
implements Handler<D, C> {
    public static final String COMPONENT_CODE = "secH";
    private final GeminiApplication application;
    private final ComponentLog log;
    private final PyxisSecurity security;
    private String[] publicCommands = new String[0];

    public SecureHandler(GeminiApplication application) {
        this.application = application;
        this.security = application.getSecurity();
        this.log = application.getLog(COMPONENT_CODE);
    }

    @Override
    public abstract String getDescription();

    @Override
    public abstract int getPriority();

    @Override
    public boolean acceptRequest(D dispatcher, C context, String command) {
        return this.isPublic(command) || this.security.isLoggedIn((Context)context);
    }

    @Override
    public boolean handleRequest(D dispatcher, C context, String command) {
        this.security.getForceLoginRejector().reject((Context)context, null);
        return true;
    }

    protected GeminiApplication getApplication() {
        return this.application;
    }

    protected PyxisSecurity getSecurity() {
        return this.security;
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    public String[] getPublicCommands() {
        return this.publicCommands;
    }

    public void setPublicCommands(String[] publicCommands) {
        this.publicCommands = publicCommands;
    }

    protected boolean isPublic(String command) {
        if (this.publicCommands.length == 0) {
            return false;
        }
        return StringHelper.equalsIgnoreCase(command, this.publicCommands);
    }

    protected String getConfigurationPrefix() {
        return "SecureHandler.";
    }
}

