/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.handler;

import com.techempower.data.DatabaseConnector;
import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.handler.SiteTestHandler;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;

public class SiteTestDbTest
extends EndableThread {
    public static final long QUICK_RETURN_TIMING = 1000L;
    private final SiteTestHandler<?, ?> handler;
    private final ComponentLog log;
    private int runNumber;
    private long lastRun;
    private int quickReturnRetries = 1;

    public <D extends BasicDispatcher, C extends Context> SiteTestDbTest(SiteTestHandler<D, C> handler) {
        super("Site Tester Thread (" + handler.getApplication().getVersion().getProductName() + ")");
        this.handler = handler;
        this.log = handler.getLog();
    }

    public void setRunNumber(int runNumber) {
        this.runNumber = runNumber;
    }

    public void setQuickReturnRetries(int retries) {
        this.quickReturnRetries = retries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setStartTime();
        this.log.log("SiteTest DB test thread starting.", 30);
        int retryNumber = 0;
        while (this.checkPause()) {
            SiteTestDbTest siteTestDbTest;
            try {
                Throwable throwable = null;
                siteTestDbTest = null;
                try (DatabaseConnector dbConn = this.handler.getConnectorFactory().getConnector(this.handler.getDbQuery());){
                    this.lastRun = System.currentTimeMillis();
                    this.log.log("Running a database test.", 10);
                    this.log.log("Query: " + this.handler.getDbQuery(), 10);
                    this.log.log("Expected result: " + this.handler.getResultField() + " = " + this.handler.getResultValue(), 0);
                    if (dbConn != null) {
                        dbConn.runQuery();
                        this.log.log("Test query complete.", 0);
                        if (dbConn.more()) {
                            this.log.log("Gathering result from column " + this.handler.getResultField(), 0);
                            String result = dbConn.getFieldByName(this.handler.getResultField());
                            this.log.log("Actual result: " + result, 10);
                            retryNumber = this.handler.getResultValue().equals(result) ? this.handleSuccessState() : this.handleFailureState("Database test returned " + result + ".", retryNumber);
                        } else {
                            retryNumber = this.handleFailureState("No results from database test.", retryNumber);
                        }
                    } else {
                        retryNumber = this.handleFailureState("Database connection is null.", retryNumber);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exc) {
                retryNumber = this.handleFailureState("Exception: " + exc, retryNumber);
            }
            try {
                Thread.sleep(100L);
                if (retryNumber != 0) continue;
                int currentRunNumber = this.runNumber;
                while (currentRunNumber == this.runNumber) {
                    siteTestDbTest = this;
                    synchronized (siteTestDbTest) {
                        if (currentRunNumber == this.runNumber) {
                            this.wait();
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.log.log("SiteTest DB test thread stopping.", 30);
    }

    protected int handleFailureState(String description, int retryNumber) {
        this.log.log(description, 50);
        long now = System.currentTimeMillis();
        if (retryNumber < this.quickReturnRetries && this.handler.isGood() && now - this.lastRun < 1000L) {
            this.log.log("Failure returned quickly; will retry.");
            return retryNumber + 1;
        }
        this.handler.setDbTestResult(false, this.runNumber);
        return 0;
    }

    protected int handleSuccessState() {
        this.handler.setDbTestResult(true, this.runNumber);
        return 0;
    }

    public synchronized void proceed(int newRunNumber) {
        this.runNumber = newRunNumber;
        this.notifyAll();
    }

    @Override
    public synchronized void setKeepRunning(boolean keepRunning) {
        super.setKeepRunning(keepRunning);
        this.notifyAll();
    }

    @Override
    public String toString() {
        long diff = (System.currentTimeMillis() - this.lastRun) / 1000L;
        String lastRunTime = this.lastRun == 0L ? "[not yet run]" : "last run " + diff + " sec ago";
        return "Site Test Thread (at test #" + this.runNumber + "; " + lastRunTime + ")";
    }
}

