/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.handler;

import com.techempower.asynchronous.Asynchronous;
import com.techempower.data.ConnectorFactory;
import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Handler;
import com.techempower.gemini.handler.SiteTestDbTest;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;

public class SiteTestHandler<D extends BasicDispatcher, C extends Context>
implements Handler<D, C>,
Configurable,
Asynchronous {
    public static final String COMPONENT_CODE = "hSTs";
    public static final String CMD_PREFIX = "gemini-test-";
    public static final String CMD_DB_TEST = "gemini-test-db";
    public static final String CMD_SPECIFIC_TEST = "gemini-test-specific";
    private int intervalSeconds = 5;
    private int timeoutSeconds = 30;
    private String queryToExecute = "SELECT '1' AS 'Result';";
    private String fieldToCheck = "Result";
    private String valueToCheck = "1";
    private final GeminiApplication app;
    private ComponentLog log;
    private String confPrefix = "SiteTest.";
    private boolean currentStateGood = true;
    private long intervalMillis = 5000L;
    private long nextRun = 0L;
    private long timeoutMillis = 30000L;
    private long currentTimeout;
    private int runNumber = 0;
    private ConnectorFactory connectorFactory;
    private boolean lowPriority = true;
    private SiteTestDbTest dbTester;
    private boolean testRunning = false;

    public SiteTestHandler(GeminiApplication application, String confPrefix) {
        this.app = application;
        this.log = application.getLog(COMPONENT_CODE);
        if (StringHelper.isNonEmpty(confPrefix)) {
            this.confPrefix = confPrefix;
        }
        this.dbTester = new SiteTestDbTest(this);
        this.app.getConfigurator().addConfigurable(this);
        this.app.addAsynchronous(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.queryToExecute = props.getProperty(String.valueOf(this.confPrefix) + "Query", this.queryToExecute);
        this.fieldToCheck = props.getProperty(String.valueOf(this.confPrefix) + "ResultField", this.fieldToCheck);
        this.valueToCheck = props.getProperty(String.valueOf(this.confPrefix) + "ExpectedResult", this.valueToCheck);
        this.intervalSeconds = props.getIntegerProperty(String.valueOf(this.confPrefix) + "AllowedInterval", this.intervalSeconds);
        this.intervalMillis = (long)this.intervalSeconds * 1000L;
        this.timeoutSeconds = props.getIntegerProperty(String.valueOf(this.confPrefix) + "Timeout", this.timeoutSeconds);
        this.timeoutMillis = (long)this.timeoutSeconds * 1000L;
        this.lowPriority = props.getYesNoProperty("LowPriority", this.lowPriority);
        this.setDbTesterPriority();
    }

    public GeminiApplication getApplication() {
        return this.app;
    }

    private void setDbTesterPriority() {
        if (this.lowPriority) {
            this.dbTester.setPriority(1);
        } else {
            this.dbTester.setPriority(5);
        }
    }

    @Override
    public String getDescription() {
        return "Site Test Handler handles site livelihood tests from monitoring tools.";
    }

    @Override
    public int getPriority() {
        return -1000;
    }

    @Override
    public boolean acceptRequest(BasicDispatcher dispatcher, Context context, String command) {
        return command.startsWith(CMD_PREFIX);
    }

    @Override
    public boolean handleRequest(BasicDispatcher dispatcher, Context context, String command) {
        if (command.equals(CMD_DB_TEST)) {
            return this.runDbTest(dispatcher, context);
        }
        if (command.equals(CMD_SPECIFIC_TEST)) {
            return this.runSpecificTest(dispatcher, context);
        }
        return false;
    }

    public boolean runDbTest(BasicDispatcher dispatcher, Context context) {
        long timeNow = System.currentTimeMillis();
        if (!this.testRunning && timeNow > this.nextRun) {
            this.testRunning = true;
            ++this.runNumber;
            this.currentTimeout = timeNow + this.timeoutMillis;
            this.log.log("Requesting a DB test.", 10);
            this.dbTester.proceed(this.runNumber);
            this.nextRun = timeNow + this.intervalMillis;
        }
        if (this.testRunning && timeNow > this.currentTimeout) {
            this.log.log("Last test exceeded permissible time.", 50);
            this.testRunning = false;
            this.currentStateGood = false;
        }
        if (this.currentStateGood) {
            this.log.log("Returning success.", 10);
            this.success(context, "");
        } else {
            this.log.log("Returning failure.", 30);
            this.failure(context, "");
        }
        return true;
    }

    public void setDbTestResult(boolean result, int runNumber) {
        if (this.runNumber == runNumber) {
            this.currentStateGood = result;
            this.testRunning = false;
            this.log.log("DB test result set to " + result, 10);
        }
    }

    public boolean runSpecificTest(BasicDispatcher dispatcher, Context context) {
        this.log.log("Un-implemented SiteTestHandler.runSpecificTest called.");
        this.failure(context, "Application-specific test not implemented; this test is meaningless.");
        return true;
    }

    public boolean isGood() {
        return this.currentStateGood;
    }

    protected ConnectorFactory getConnectorFactory() {
        return this.connectorFactory;
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    protected String getDbQuery() {
        return this.queryToExecute;
    }

    protected String getResultField() {
        return this.fieldToCheck;
    }

    protected String getResultValue() {
        return this.valueToCheck;
    }

    protected long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    protected void success(Context context, String note) {
        context.setContentType("text/html");
        context.print("<html><body>Success - " + note + "</body></head>");
    }

    protected void failure(Context context, String note) {
        context.setContentType("text/html");
        context.print("<html><body>Failure - " + note + "</body></head>");
    }

    @Override
    public void begin() {
        this.connectorFactory = this.app.getConnectorFactory();
        this.dbTester.start();
    }

    @Override
    public void end() {
        this.dbTester.setKeepRunning(false);
        this.dbTester = new SiteTestDbTest(this);
        this.setDbTesterPriority();
    }

    public String getConfigurationPrefix() {
        return this.confPrefix;
    }
}

