/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.handler;

import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Handler;
import com.techempower.gemini.LegacyContext;
import com.techempower.helper.StringHelper;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class StaticHandler
implements Handler<BasicDispatcher, LegacyContext>,
Configurable {
    public static final String COMPONENT_CODE = "hSta";
    public static final String PROPS_PREFIX = "StaticHandler.";
    public static final String PROPS_COMMAND_PREFIX = "cmd.";
    public static final String PROPS_CONTENT_PATH = "ContentPath";
    public static final String PROPS_CONTENT_EXT = "ContentExtension";
    public static final String CMD_STATIC_PREFIX = "ct-";
    public static final String DEFAULT_CONTENT_PATH = "static/";
    public static final String DEFAULT_CONTENT_EXT = "jsp";
    private Map<String, String> commandsToFiles = new HashMap<String, String>();
    private String contentPath = "static/";
    private String contentExt = "jsp";

    public StaticHandler(GeminiApplication application) {
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties handlerProps = props.extractProperties(PROPS_PREFIX, true);
        this.contentPath = handlerProps.getProperty(PROPS_CONTENT_PATH, this.contentPath);
        this.contentPath = this.contentPath.replace('\\', '/');
        if (this.contentPath.startsWith("/")) {
            this.contentPath = this.contentPath.substring(1);
        }
        if (StringHelper.isNonEmpty(this.contentPath) && !this.contentPath.endsWith("/")) {
            this.contentPath = String.valueOf(this.contentPath) + "/";
        }
        this.contentExt = handlerProps.getProperty(PROPS_CONTENT_EXT, this.contentExt);
        if (this.contentExt.startsWith(".")) {
            this.contentExt = this.contentExt.substring(1);
        }
        EnhancedProperties cmdProps = handlerProps.extractProperties(PROPS_COMMAND_PREFIX, true);
        HashMap<String, String> commands = new HashMap<String, String>();
        Enumeration<?> names = cmdProps.propertyNames();
        while (names.hasMoreElements()) {
            String command = (String)names.nextElement();
            String page = cmdProps.getProperty(command, "");
            if (!StringHelper.isNonEmpty(command) || !StringHelper.isNonEmpty(page)) continue;
            if (page.indexOf(46) < 0) {
                page = String.valueOf(page) + "." + this.contentExt;
            }
            commands.put(command.toLowerCase(), page);
        }
        this.commandsToFiles = commands;
    }

    @Override
    public String getDescription() {
        return "Static Content Handler";
    }

    @Override
    public int getPriority() {
        return -1000;
    }

    @Override
    public boolean acceptRequest(BasicDispatcher dispatcher, LegacyContext context, String command) {
        return command.startsWith(CMD_STATIC_PREFIX);
    }

    @Override
    public boolean handleRequest(BasicDispatcher dispatcher, LegacyContext context, String command) {
        String pageName = this.getPageForCommand(context, command);
        if (StringHelper.isNonEmptyTrimmed(pageName)) {
            return context.render(pageName);
        }
        return false;
    }

    protected String getPageForCommand(Context context, String command) {
        if (command.length() <= CMD_STATIC_PREFIX.length() || !StringHelper.startsWithIgnoreCase(command, CMD_STATIC_PREFIX)) {
            return "";
        }
        String cmdKey = command.substring(CMD_STATIC_PREFIX.length()).toLowerCase();
        String pageName = this.commandsToFiles.get(cmdKey);
        if (StringHelper.isEmpty(pageName)) {
            pageName = String.valueOf(cmdKey) + "." + this.contentExt;
        }
        return String.valueOf(this.contentPath) + pageName;
    }
}

