/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.handler;

import com.techempower.asynchronous.Asynchronous;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.configuration.ConfigurationError;
import com.techempower.gemini.path.MethodPathHandler;
import com.techempower.gemini.path.UriAware;
import com.techempower.gemini.path.annotation.PathDefault;
import com.techempower.gemini.path.annotation.PathSegment;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.text.SynchronizedSimpleDateFormat;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ThreadDumpHandler<C extends Context>
extends MethodPathHandler<C>
implements Configurable,
UriAware,
Asynchronous {
    public static final String COMPONENT_CODE = "hThd";
    public static final String DEFAULT_PROPS_PREFIX = "ThreadDump.";
    public static final int MEGABYTE = 0x100000;
    public static final String DEFAULT_ROLE = "threaddump";
    public static final String ANY_IP = "any";
    private static ThreadDumpHandler<?> INSTANCE;
    private String propsPrefix = "ThreadDump.";
    private String passphrase = null;
    private String authorizedIP = "any";
    private SynchronizedSimpleDateFormat dateFormatter = new SynchronizedSimpleDateFormat();
    private String dumpOnStopLocation = "";
    private boolean useJmx = true;

    public ThreadDumpHandler(GeminiApplication application, String propsPrefix) {
        super(application, COMPONENT_CODE);
        if (propsPrefix != null) {
            this.propsPrefix = propsPrefix;
        }
        application.getConfigurator().addConfigurable(this);
        INSTANCE = this;
    }

    public ThreadDumpHandler(GeminiApplication application) {
        this(application, null);
    }

    public static ThreadDumpHandler<?> getInstance() {
        return INSTANCE;
    }

    protected boolean isJmx(Context context) {
        boolean jmx = this.useJmx;
        if (jmx && !this.query().getBooleanLenient("jmx", jmx)) {
            jmx = false;
        }
        return jmx;
    }

    protected boolean isAuthorized(Context context) {
        return this.passphrase != null && this.query().get(this.passphrase) != null && (this.authorizedIP.equalsIgnoreCase(ANY_IP) || context.getClientID().equals(this.authorizedIP));
    }

    protected static List<ThreadDescriptor> getThreads(boolean isUsingJmx) {
        Map<Thread, StackTraceElement[]> currentThreads = Thread.getAllStackTraces();
        ThreadInfo[] allInfos = null;
        if (isUsingJmx) {
            allInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        }
        ArrayList<ThreadDescriptor> toReturn = new ArrayList<ThreadDescriptor>();
        ThreadInfo info = null;
        for (Map.Entry<Thread, StackTraceElement[]> entry : currentThreads.entrySet()) {
            Thread thread = entry.getKey();
            if (allInfos != null) {
                info = null;
                int i = 0;
                while (i < allInfos.length) {
                    if (allInfos[i].getThreadId() == thread.getId()) {
                        info = allInfos[i];
                        break;
                    }
                    ++i;
                }
            }
            ThreadDescriptor desc = new ThreadDescriptor(thread, info, entry.getValue());
            toReturn.add(desc);
        }
        Collections.sort(toReturn);
        return toReturn;
    }

    @PathDefault
    public boolean threadDump(Context context) {
        boolean jmx = this.isJmx(context);
        long startTime = System.currentTimeMillis();
        this.l("Thread dump requested.");
        context.setContentType("text/html");
        this.writeHeader(context);
        List<ThreadDescriptor> threadDescs = ThreadDumpHandler.getThreads(jmx);
        int half = threadDescs.size() / 2 + threadDescs.size() % 2;
        int position = 0;
        context.print("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">");
        context.print("<tr><td width=\"50%\">");
        Iterator<ThreadDescriptor> threads = threadDescs.iterator();
        while (threads.hasNext()) {
            if (position == half) {
                context.print("</td><td>&nbsp;&nbsp;</td><td width=\"50%\">");
            }
            ++position;
            ThreadDescriptor desc = threads.next();
            int priority = desc.thread.getPriority();
            context.print("<div class=\"thread\">");
            context.print("<div class=\"threadname\">");
            context.print(String.valueOf(desc.thread.getName()) + " [ID: " + desc.thread.getId() + "; Priority: " + priority + "]");
            context.print("</div>");
            context.print("<div class=\"threaddesc\">");
            context.print(desc.thread.toString());
            context.print("</div>");
            context.print("<div class=\"stackblock\">");
            StackTraceElement[] stack = desc.stack;
            if (stack != null && stack.length > 0) {
                String stackStyle;
                String stackfirstStyle;
                if (priority < 5) {
                    stackfirstStyle = "stacklowfirst";
                    stackStyle = "stacklow";
                } else if (priority > 5) {
                    stackfirstStyle = "stackhighfirst";
                    stackStyle = "stackhigh";
                } else {
                    stackfirstStyle = "stackfirst";
                    stackStyle = "stack";
                }
                int i = 0;
                while (i < stack.length) {
                    if (i == 0) {
                        context.print("<div class=\"" + stackfirstStyle + "\">" + stack[i].toString() + "</div>");
                    } else {
                        context.print("<div class=\"" + stackStyle + "\">" + stack[i].toString() + "</div>");
                    }
                    ++i;
                }
            } else {
                context.print("<div class=\"stackunavailable\">No stack trace available.</div>");
            }
            if (desc.info != null) {
                MonitorInfo[] locks = desc.info.getLockedMonitors();
                int i = 0;
                while (i < locks.length) {
                    context.print("<div class=\"ownlock" + (i == 0 ? "first" : "") + "\">Owns lock on instance " + Integer.toHexString(locks[i].getIdentityHashCode()) + " of " + locks[i].getClassName() + "</div>");
                    ++i;
                }
                long owner = desc.info.getLockOwnerId();
                if (desc.info.getLockInfo() != null) {
                    context.print("<div class=\"block\">Blocked on lock " + Integer.toHexString(desc.info.getLockInfo().getIdentityHashCode()) + " of " + desc.info.getLockInfo().getClassName() + (owner >= 0L ? " owned by thread " + owner + " (" + desc.info.getLockOwnerName() + ")" : "") + "</div>");
                }
            }
            context.print("</div>");
            context.print("</div>");
        }
        context.print("</td></tr></table>");
        long msTaken = System.currentTimeMillis() - startTime;
        this.l("Thread dump complete, took " + msTaken + " ms.");
        this.writeFooter(context, msTaken);
        return true;
    }

    @PathSegment(value="plain")
    public boolean threadDumpPlainText(Context context) {
        boolean jmx = this.isJmx(context);
        long startTime = System.currentTimeMillis();
        this.l("Thread dump requested.");
        context.setContentType("text/plain");
        context.print("Gemini Thread Dump");
        context.print("");
        long uptime = this.app().getUptime();
        context.print(String.valueOf(this.dateFormatter.format(new Date())) + " - " + DateHelper.getHumanDuration(uptime, 2) + " uptime (" + uptime + " millis) - " + Runtime.getRuntime().freeMemory() / 0x100000L + " MiB free; " + Runtime.getRuntime().totalMemory() / 0x100000L + " MiB allocated - " + this.app().getVersion().getVerboseDescription());
        context.print("");
        List<ThreadDescriptor> threadDescs = ThreadDumpHandler.getThreads(jmx);
        for (ThreadDescriptor desc : threadDescs) {
            int priority = desc.thread.getPriority();
            context.print(String.valueOf(desc.thread.getName()) + " [Priority: " + priority + "]");
            context.print(desc.thread.toString());
            StackTraceElement[] stack = desc.stack;
            if (stack != null && stack.length > 0) {
                int i = 0;
                while (i < stack.length) {
                    context.print("  " + stack[i].toString());
                    ++i;
                }
            } else {
                context.print("No stack trace available.");
            }
            if (desc.info != null) {
                MonitorInfo[] locks = desc.info.getLockedMonitors();
                int i = 0;
                while (i < locks.length) {
                    context.print("  + Owns lock on instance " + Integer.toHexString(locks[i].getIdentityHashCode()) + " of " + locks[i].getClassName());
                    ++i;
                }
                long owner = desc.info.getLockOwnerId();
                if (desc.info.getLockInfo() != null) {
                    context.print("  - Blocked on lock " + Integer.toHexString(desc.info.getLockInfo().getIdentityHashCode()) + " of " + desc.info.getLockInfo().getClassName() + (owner >= 0L ? " owned by thread " + owner + " (" + desc.info.getLockOwnerName() + ")" : ""));
                }
            }
            context.print("");
        }
        long msTaken = System.currentTimeMillis() - startTime;
        this.l("Thread dump complete, took " + msTaken + " ms.");
        return true;
    }

    protected void writeHeader(Context context) {
        context.print("<html>");
        context.print("<head>");
        context.print("<title>Gemini Thread Dump</title>");
        context.print("<style>");
        context.print("BODY { background-color: white; color: black; margin: 10px 10px 10px 10px; }");
        context.print("P, TD, DIV { font-family: Tahoma, Arial, Helvetica, Sans-serif; font-size: 10px; color: black; }");
        context.print("TD { vertical-align: top; }");
        context.print("H1 { font-family: Tahoma, Arial, Helvetica, Sans-serif; font-size: 13px; font-weight: Bold; color: #203040; }");
        context.print("H2 { font-family: Tahoma, Arial, Helvetica, Sans-serif; font-size: 12px; font-weight: Bold; color: #304050; }");
        context.print(".thread { border: 1px solid #405060; margin: 10px 0px 10px 0px; }");
        context.print(".threadname { font-weight: Bold; font-size: 12px; background-color: #D0E0F0; padding: 2px 5px 0px 5px; }");
        context.print(".threaddesc { border-bottom: 1px solid #8090A0; font-size: 9px; background-color: #D0E0F0; padding: 0px 5px 2px 5px; }");
        context.print(".stackblock { padding: 5px 5px 5px 5px; }");
        context.print(".stackunavailable { border-top: 1px solid #707070; border-left: 1px solid #707070; border-right: 1px solid #707070; border-bottom: 1px solid #707070; background-color: #E8E8E8; padding: 0px 2px 0px 2px; color: #707070 }");
        context.print(".stackfirst { border-top: 1px solid #8090A0; border-left: 1px solid #8090A0; border-right: 1px solid #8090A0; border-bottom: 1px solid #8090A0; background-color: #E0F0FF; padding: 0px 2px 0px 2px; }");
        context.print(".stack { border-left: 1px solid #8090A0; border-right: 1px solid #8090A0; border-bottom: 1px solid #8090A0; background-color: #E0F0FF; padding: 0px 2px 0px 2px; }");
        context.print(".stacklowfirst { border-top: 1px solid #80A090; border-left: 1px solid #80A090; border-right: 1px solid #80A090; border-bottom: 1px solid #80A090; background-color: #E0FFF0; padding: 0px 2px 0px 2px; }");
        context.print(".stacklow { border-left: 1px solid #80A090; border-right: 1px solid #80A090; border-bottom: 1px solid #80A090; background-color: #E0FFF0; padding: 0px 2px 0px 2px; }");
        context.print(".stackhighfirst { border-top: 1px solid #A09090; border-left: 1px solid #A09090; border-right: 1px solid #A09090; border-bottom: 1px solid #A09090; background-color: #FFE8E8; padding: 0px 2px 0px 2px; }");
        context.print(".stackhigh { border-left: 1px solid #A09080; border-right: 1px solid #A09090; border-bottom: 1px solid #A09090; background-color: #FFE8E8; padding: 0px 2px 0px 2px; }");
        context.print(".ownlockfirst { border-top: 1px solid #D4E400; border-left: 1px solid #D4E400; border-right: 1px solid #D4E400; border-bottom: 1px solid #D4E400; background-color: #F8FFCF; padding: 0px 2px 0px 2px; margin-top: 4px}");
        context.print(".ownlock { border-left: 1px solid #D4E400; border-right: 1px solid #D4E400; border-bottom: 1px solid #D4E400; background-color: #F8FFCF; padding: 0px 2px 0px 2px; }");
        context.print(".block { border-top: 1px solid #C8B000; border-left: 1px solid #C8B000; border-right: 1px solid #C8B000; border-bottom: 1px solid #C8B000; background-color: #FFE0BF; padding: 0px 2px 0px 2px; margin-top: 4px}");
        context.print("</style>");
        context.print("</head>");
        context.print("<body>");
        context.print("<h1>Gemini Thread Dump</h1>");
        long uptime = this.app().getUptime();
        context.print("<h2>" + this.dateFormatter.format(new Date()) + " - " + DateHelper.getHumanDuration(uptime, 2) + " uptime (" + uptime + " millis) - " + Runtime.getRuntime().freeMemory() / 0x100000L + " MiB free; " + Runtime.getRuntime().totalMemory() / 0x100000L + " MiB allocated - " + this.app().getVersion().getVerboseDescription() + "</h2>");
    }

    protected void writeFooter(Context context, long msTaken) {
        context.print("<p>Operation took " + msTaken + " ms.  <a href='" + this.getBaseUri() + "/plain'>Plaintext version</a></p>");
        context.print("</body>");
        context.print("</html>");
    }

    protected void writeDumpFile(String location) {
        String filename = String.valueOf(location) + "thddmp-" + DateHelper.STANDARD_FILENAME_FORMAT.format(new Date()) + ".txt";
        this.l("Thread dump: " + filename);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PrintWriter pw = new PrintWriter(filename);){
                pw.println("Gemini Stop-time Thread Dump");
                pw.println("");
                long uptime = this.app().getUptime();
                pw.println(String.valueOf(this.dateFormatter.format(new Date())) + " - " + DateHelper.getHumanDuration(uptime, 2) + " uptime (" + uptime + " millis) - " + Runtime.getRuntime().freeMemory() / 0x100000L + " MiB free; " + Runtime.getRuntime().totalMemory() / 0x100000L + " MiB allocated - " + this.app().getVersion().getVerboseDescription());
                pw.println("");
                List<ThreadDescriptor> threadDescs = ThreadDumpHandler.getThreads(this.useJmx);
                for (ThreadDescriptor desc : threadDescs) {
                    int priority = desc.thread.getPriority();
                    pw.println(String.valueOf(desc.thread.getName()) + " [Priority: " + priority + "]");
                    pw.println(desc.thread.toString());
                    StackTraceElement[] stack = desc.stack;
                    if (stack != null && stack.length > 0) {
                        int i = 0;
                        while (i < stack.length) {
                            pw.println("  " + stack[i].toString());
                            ++i;
                        }
                    } else {
                        pw.println("No stack trace available.");
                    }
                    if (desc.info != null) {
                        MonitorInfo[] locks = desc.info.getLockedMonitors();
                        int i = 0;
                        while (i < locks.length) {
                            pw.println("  + Owns lock on instance " + Integer.toHexString(locks[i].getIdentityHashCode()) + " of " + locks[i].getClassName());
                            ++i;
                        }
                        long owner = desc.info.getLockOwnerId();
                        if (desc.info.getLockInfo() != null) {
                            pw.println("  - Blocked on lock " + Integer.toHexString(desc.info.getLockInfo().getIdentityHashCode()) + " of " + desc.info.getLockInfo().getClassName() + (owner >= 0L ? " owned by thread " + owner + " (" + desc.info.getLockOwnerName() + ")" : ""));
                        }
                    }
                    pw.println("");
                    pw.flush();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            this.l("Exception while writing thread dump file: " + exc);
        }
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.passphrase = props.getProperty(String.valueOf(this.propsPrefix) + "Passphrase", this.passphrase);
        this.authorizedIP = props.getProperty(String.valueOf(this.propsPrefix) + "AuthorizedIP", this.authorizedIP);
        this.useJmx = props.getYesNoProperty(String.valueOf(this.propsPrefix) + "UseJmx", this.useJmx);
        this.dumpOnStopLocation = props.getProperty(String.valueOf(this.propsPrefix) + "DumpOnStopLocation", this.dumpOnStopLocation);
        if (StringHelper.isEmptyTrimmed(this.passphrase)) {
            this.passphrase = null;
            throw new ConfigurationError("Required configuration paramter '" + this.propsPrefix + "Passphrase' was missing.  This must be " + "specified and must have a non-empty value.");
        }
        if (StringHelper.isNonEmpty(this.dumpOnStopLocation)) {
            this.app().addAsynchronous(this);
        } else {
            this.app().removeAsynchronous(this);
        }
    }

    @Override
    public void begin() {
    }

    @Override
    public void end() {
        if (StringHelper.isNonEmpty(this.dumpOnStopLocation)) {
            this.writeDumpFile(this.dumpOnStopLocation);
        }
    }

    public static class ThreadDescriptor
    implements Comparable<ThreadDescriptor> {
        private Thread thread;
        private ThreadInfo info;
        private StackTraceElement[] stack;

        public ThreadDescriptor(Thread thread, ThreadInfo info, StackTraceElement[] stack) {
            this.thread = thread;
            this.info = info;
            this.stack = stack;
        }

        public Thread getThread() {
            return this.thread;
        }

        public ThreadInfo getThreadInfo() {
            return this.info;
        }

        public StackTraceElement[] getStack() {
            return this.stack;
        }

        @Override
        public int compareTo(ThreadDescriptor other) {
            return this.thread.getName().compareTo(other.thread.getName());
        }
    }
}

