/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.internationalization;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.internationalization.GeminiLocaleManager;
import com.techempower.gemini.internationalization.GeminiResources;
import com.techempower.gemini.internationalization.ResourceManager;
import com.techempower.helper.StringHelper;
import com.techempower.util.EnhancedProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class FileResourceManager
extends ResourceManager {
    public static final String FILE_EXTENSION = ".resources";
    public static final String DEFAULT_RESOURCE_LOCATION = "${Servlet.WebInf}" + File.separatorChar + "internationalization" + File.separatorChar;
    private String resourceLocation;
    private Map<Locale, GeminiResources> loadedResources = new HashMap<Locale, GeminiResources>();
    private volatile GeminiResources rootResources;

    public FileResourceManager(GeminiApplication application, GeminiLocaleManager localeManager, EnhancedProperties props) {
        super(application, localeManager, props);
        this.resourceLocation = props.getProperty("I18n.ResourcesLocation", DEFAULT_RESOURCE_LOCATION);
        this.getLog().log("Resources location: " + this.resourceLocation);
    }

    @Override
    public GeminiResources get(Locale locale) {
        if (locale == null || StringHelper.isEmpty(locale.getLanguage())) {
            return this.getRootResources();
        }
        GeminiResources resources = this.loadedResources.get(locale);
        if (resources == null) {
            resources = this.load(locale);
        }
        return resources;
    }

    protected synchronized GeminiResources load(Locale locale) {
        Properties props;
        Locale parentLocale;
        GeminiResources parentResources = this.getRootResources();
        GeminiResources toReturn = null;
        if (locale != null && locale.getCountry() != null && !(parentLocale = new Locale(locale.getLanguage())).equals(locale)) {
            parentResources = this.get(parentLocale);
        }
        toReturn = (props = this.loadProperties(this.getResourceFilename(locale))) != null ? new GeminiResources(this.getApplication(), props, locale, parentResources) : parentResources;
        HashMap<Locale, GeminiResources> newMap = new HashMap<Locale, GeminiResources>(this.loadedResources);
        newMap.put(locale, toReturn);
        this.loadedResources = newMap;
        return toReturn;
    }

    protected String getResourceFilename(Locale locale) {
        String filename = "";
        filename = locale == null || StringHelper.isEmpty(locale.getLanguage()) ? String.valueOf(this.getApplication().getVersion().getAbbreviatedProductName()) + FILE_EXTENSION : (StringHelper.isNonEmpty(locale.getLanguage()) && StringHelper.isNonEmpty(locale.getCountry()) ? String.valueOf(this.getApplication().getVersion().getAbbreviatedProductName()) + "-" + locale.getLanguage() + "-" + locale.getCountry() + FILE_EXTENSION : String.valueOf(this.getApplication().getVersion().getAbbreviatedProductName()) + "-" + locale.getLanguage() + FILE_EXTENSION);
        return String.valueOf(this.resourceLocation) + filename;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties loadProperties(String filename) {
        File resourceFile = new File(filename);
        if (!resourceFile.exists()) {
            this.getLog().log("Resources file not found: \"" + filename + "\"");
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileInputStream is = new FileInputStream(resourceFile);
                try {
                    Properties properties;
                    block17: {
                        InputStreamReader in = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
                        try {
                            Properties props = new Properties();
                            props.load(in);
                            this.getLog().log("Loaded resources from \"" + filename + "\".");
                            properties = props;
                            return properties;
                        }
                        finally {
                            if (in == null) break block17;
                            ((Reader)in).close();
                        }
                    }
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    return properties;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    ((InputStream)is).close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException ioexception) {
            this.getLog().log("Exception while reading resource file: \"" + filename + "\"", ioexception);
            return null;
        }
    }

    @Override
    public boolean save() {
        boolean saved = this.save(null, this.getRootResources());
        for (Locale locale : this.loadedResources.keySet()) {
            if (this.save(locale, this.loadedResources.get(locale))) continue;
            saved = false;
        }
        return saved;
    }

    @Override
    public boolean save(GeminiResources resources) {
        return this.save(resources.getLocale(), resources);
    }

    @Override
    public boolean save(Locale locale) {
        if (!this.loadedResources.containsKey(locale)) {
            return false;
        }
        return this.save(locale, this.loadedResources.get(locale));
    }

    protected boolean save(Locale locale, GeminiResources resource) {
        block14: {
            File dir = new File(this.resourceLocation);
            if (!dir.exists()) {
                dir.mkdir();
            }
            String filename = this.getResourceFilename(locale);
            Throwable throwable = null;
            Object var6_8 = null;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
            try {
                resource.getAll().store(writer, null);
                if (writer == null) break block14;
            }
            catch (Throwable throwable2) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.getLog().log("::save - threw exception while trying to write to file.", e);
                        return false;
                    }
                }
            }
            writer.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GeminiResources getRootResources() {
        if (this.rootResources == null) {
            FileResourceManager fileResourceManager = this;
            synchronized (fileResourceManager) {
                if (this.rootResources == null) {
                    GeminiResources newRootResources = null;
                    Properties props = this.loadProperties(this.getResourceFilename(null));
                    newRootResources = props != null ? new GeminiResources(this.getApplication(), props, null, this.getLocaleManager().getDefaultResources()) : this.getLocaleManager().getDefaultResources();
                    this.rootResources = newRootResources;
                }
            }
        }
        return this.rootResources;
    }

    @Override
    public void reset() {
        this.loadedResources.clear();
    }

    @Override
    public void reset(Locale locale) {
        this.loadedResources.remove(locale);
    }
}

