/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.internationalization;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.internationalization.DefaultGeminiResources;
import com.techempower.gemini.internationalization.FileResourceManager;
import com.techempower.gemini.internationalization.GeminiResources;
import com.techempower.gemini.internationalization.ResourceManager;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.Locale;

public class GeminiLocaleManager
implements Configurable {
    public static final String DEFAULT_LANGUAGE_CODE = "en";
    public static final String DEFAULT_COUNTRY_CODE = "US";
    public static final String COMPONENT_CODE = "loca";
    private static final String SESSION_LOCALE_SUFFIX = "-Locale";
    private static GeminiLocaleManager instance;
    private final ComponentLog log;
    private volatile ResourceManager resourceManager;
    private final GeminiApplication application;
    private final String productName;
    private final Locale defaultLocale;
    private final GeminiResources defaultResources;

    public GeminiLocaleManager(GeminiApplication application, GeminiResources defaultResources) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.productName = application.getVersion().getAbbreviatedProductName();
        this.defaultLocale = new Locale(DEFAULT_LANGUAGE_CODE, DEFAULT_COUNTRY_CODE);
        if (defaultResources != null) {
            this.defaultResources = defaultResources;
        } else {
            this.log.log("Instantiating built-in default (US English) resources.");
            this.defaultResources = new DefaultGeminiResources(application);
        }
        instance = this;
    }

    public GeminiLocaleManager(GeminiApplication application) {
        this(application, null);
    }

    public static GeminiLocaleManager getInstance() {
        return instance;
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.resourceManager = new FileResourceManager(this.application, this, props);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public GeminiResources getDefaultResources() {
        return this.defaultResources;
    }

    public void setLocale(Context context, String languageID, String countryID) {
        context.session().putObject(String.valueOf(this.productName) + SESSION_LOCALE_SUFFIX, new Locale(languageID, countryID));
    }

    public void setLocale(Context context, Locale locale) {
        context.session().putObject(String.valueOf(this.productName) + SESSION_LOCALE_SUFFIX, locale);
    }

    public Locale getLocale(Context context) {
        if (context != null) {
            Locale toReturn = this.getLocaleRaw(context);
            return toReturn != null ? toReturn : this.getDefaultLocale();
        }
        return this.getDefaultLocale();
    }

    public Locale getLocaleRaw(Context context) {
        return (Locale)context.session().getObject(String.valueOf(this.productName) + SESSION_LOCALE_SUFFIX);
    }

    public GeminiResources getResources(Context context) {
        return this.getResources(this.getLocale(context));
    }

    public GeminiResources getResources(Locale locale) {
        return this.resourceManager.get(locale);
    }

    public boolean saveResources() {
        return this.resourceManager.save();
    }

    public void resetResource(Locale locale) {
        this.resourceManager.reset(locale);
    }

    public void resetResources() {
        this.resourceManager.reset();
    }

    protected GeminiApplication getApplication() {
        return this.application;
    }
}

