/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.internationalization;

import com.techempower.gemini.GeminiApplication;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class GeminiResources {
    public static final String COMPONENT_CODE = "reso";
    private static final String[] macroIndicators = new String[]{"$S1", "$S2", "$S3", "$S4", "$S5", "$S6", "$S7", "$S8", "$S9", "$SA", "$SB", "$SC", "$SD", "$SE", "$SF", "$SG", "$SH", "$SI", "$SJ", "$SK", "$SL", "$SM", "$SN", "$SO", "$SP", "$SQ", "$SR", "$SS", "$ST", "$SU"};
    private final ComponentLog log;
    private final Locale locale;
    private final GeminiResources parent;
    private Properties properties;

    protected GeminiResources(GeminiApplication app) {
        this(app, new Properties(), null, null);
    }

    protected GeminiResources(GeminiApplication app, Properties properties, Locale locale, GeminiResources parent) {
        this.log = app.getLog(COMPONENT_CODE);
        this.properties = properties;
        this.locale = locale;
        this.parent = parent;
    }

    public Properties getAll() {
        return this.properties;
    }

    public boolean hasKey(String key) {
        return this.properties.containsKey(key);
    }

    public String get(String key) {
        if (!this.hasKey(key)) {
            if (this.parent == null) {
                this.log.log("Key \"" + key + "\" does not exist in the resources.");
                return key;
            }
            return this.parent.get(key);
        }
        String value = (String)this.properties.get(key);
        if (StringHelper.isEmptyTrimmed(value)) {
            this.log.log("Value for key \"" + key + "\" is empty.");
        }
        return value;
    }

    public String get(String key, String ... macros) {
        String toExpand = this.get(key);
        if (macros != null) {
            return StringHelper.replaceSubstrings(toExpand, macroIndicators, macros);
        }
        return toExpand;
    }

    public void loadFromProperties(Properties newProperties) {
        if (this.properties == null) {
            this.properties = newProperties;
        } else {
            for (Object objKey : newProperties.keySet()) {
                String key = objKey.toString();
                if (StringHelper.isEmptyTrimmed(newProperties.getProperty(key))) continue;
                this.properties.setProperty(key, newProperties.getProperty(key));
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public GeminiResources getParent() {
        return this.parent;
    }

    public Updater updater() {
        return new Updater();
    }

    public String toString() {
        return "GeminiResources [locale: " + (this.locale != null ? this.locale.getDisplayName() : "--") + "]";
    }

    public final class Updater {
        private final Map<String, String> updates = new HashMap<String, String>();
        private String prefix = "";

        private Updater() {
        }

        public Updater prefix(String newPrefix) {
            this.prefix = newPrefix;
            return this;
        }

        public Updater put(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("Key was null.");
            }
            if (value == null) {
                throw new IllegalArgumentException("Value was null.");
            }
            this.updates.put(String.valueOf(StringHelper.isNonEmpty(this.prefix) ? this.prefix : "") + key, value);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Updater commit() {
            GeminiResources geminiResources = GeminiResources.this;
            synchronized (geminiResources) {
                Properties newProperties = (Properties)GeminiResources.this.properties.clone();
                for (String key : this.updates.keySet()) {
                    newProperties.put(key, this.updates.get(key));
                }
                GeminiResources.this.properties = newProperties;
            }
            return this;
        }
    }
}

