/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.jsp;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.LegacyContext;
import com.techempower.gemini.jsp.ScriptsAndSheets;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;

public abstract class InfrastructureJsp
implements HttpJspPage {
    public static final String COMPONENT_CODE = ".jsp";
    private ServletConfig config;
    private volatile GeminiApplication application;
    private ComponentLog log;
    private ScriptsAndSheets sas;

    protected synchronized void setApplication(GeminiApplication application) {
        if (this.application != application) {
            this.sas = new ScriptsAndSheets(application);
            this.log = application.getLog(COMPONENT_CODE);
            this.application = application;
            this.initSas();
        }
    }

    protected GeminiApplication getApplication() {
        return this.application;
    }

    public ScriptsAndSheets getSas() {
        return this.sas;
    }

    public void init(ServletConfig configuration) throws ServletException {
        this.config = configuration;
        this.jspInit();
    }

    public void jspInit() {
    }

    protected void initSas() {
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "Infrastructure JSP";
    }

    public void destroy() {
        this.jspDestroy();
    }

    public void jspDestroy() {
    }

    public static String render(String text) {
        return NetworkHelper.escapeStringForHtml(text);
    }

    public static String renderCssPath(Context context, String filename) {
        return InfrastructureJsp.render(String.valueOf(context.getInfrastructure().getCssDirectory(context)) + filename);
    }

    public static String renderHtmlPath(Context context, String filename) {
        return InfrastructureJsp.render(String.valueOf(context.getInfrastructure().getHtmlDirectory(context)) + filename);
    }

    public static String renderImagePath(Context context, String filename) {
        return InfrastructureJsp.render(String.valueOf(context.getInfrastructure().getImageDirectory(context)) + filename);
    }

    public static String renderJavaScriptPath(Context context, String filename) {
        return InfrastructureJsp.render(String.valueOf(context.getInfrastructure().getJavaScriptDirectory(context)) + filename);
    }

    public String renderJavaScript(Object object) {
        return this.getApplication().getJavaScriptWriter().write(object);
    }

    public String renderScripts(Context context, ScriptsAndSheets requestScopeSas) {
        List<String> suppressed = this.sas.getSuppressed(null);
        suppressed = requestScopeSas != null ? requestScopeSas.getSuppressed(suppressed) : suppressed;
        return String.valueOf(context.getApplication().getInfrastructure().getSas().renderScripts(context, suppressed)) + this.sas.renderScripts(context, suppressed) + (requestScopeSas != null ? requestScopeSas.renderScripts(context, suppressed) : "");
    }

    public String renderScripts(Context context) {
        return this.renderScripts(context, null);
    }

    public String renderSheets(Context context, ScriptsAndSheets requestScopeSas) {
        List<String> suppressed = this.sas.getSuppressedSheets(null);
        suppressed = requestScopeSas != null ? requestScopeSas.getSuppressedSheets(suppressed) : suppressed;
        return String.valueOf(context.getApplication().getInfrastructure().getSas().renderSheets(context, suppressed)) + this.sas.renderSheets(context, suppressed) + (requestScopeSas != null ? requestScopeSas.renderSheets(context, suppressed) : "");
    }

    public String renderSheets(Context context) {
        return this.renderSheets(context, null);
    }

    public String renderFavicon(Context context, ScriptsAndSheets requestScopeSas) {
        String fav = "";
        if (requestScopeSas != null && StringHelper.isNonEmpty(fav = requestScopeSas.renderFavicon(context))) {
            return fav;
        }
        fav = this.sas.renderFavicon(context);
        if (StringHelper.isNonEmpty(fav)) {
            return fav;
        }
        fav = context.getApplication().getInfrastructure().getSas().renderFavicon(context);
        return fav;
    }

    public String renderFavicon(Context context) {
        return this.renderFavicon(context, null);
    }

    protected void debug(String debugString) {
        LegacyContext context = (LegacyContext)Context.get();
        if (context != null) {
            this.debug(context, debugString);
        } else if (this.log != null) {
            this.log.log("[no Context] " + debugString);
        }
    }

    protected void debug(LegacyContext context, String debugString) {
        if (this.log != null) {
            this.log.log("[" + this.getCurrentPageName(context) + "] " + debugString);
        }
    }

    protected void debug(LegacyContext context, String debugString, int debugLevel) {
        if (this.log != null) {
            this.log.log("[" + this.getCurrentPageName(context) + "] " + debugString, debugLevel);
        }
    }

    protected String getCurrentPageName(LegacyContext context) {
        if ("none".equals(context.getReferencedRender())) {
            return this.getServletConfig().getServletName();
        }
        return context.getReferencedRender();
    }

    public abstract void _jspService(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;
}

