/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.jsp;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class ScriptsAndSheets {
    private static final int DEFAULT_LIST_LENGTH = 4;
    private int environment = 0;
    private List<String> scripts = null;
    private List<String> suppressedScripts = null;
    private List<Sheet> sheets = null;
    private List<String> suppressedSheets = null;
    private String favIcon = null;

    public ScriptsAndSheets(GeminiApplication application) {
        if (application != null) {
            this.environment = application.getVersion().getEnvironment();
        }
    }

    public void addScript(String development, String test, String production) {
        if (this.scripts == null) {
            this.scripts = new ArrayList<String>(4);
        }
        String toAdd = null;
        switch (this.environment) {
            case 0: {
                if (!StringHelper.isNonEmpty(development)) break;
                toAdd = development;
                break;
            }
            case 1: {
                if (!StringHelper.isNonEmpty(test)) break;
                toAdd = test;
                break;
            }
            default: {
                if (!StringHelper.isNonEmpty(production)) break;
                toAdd = production;
            }
        }
        if (toAdd != null && !this.scripts.contains(toAdd)) {
            this.scripts.add(toAdd);
        }
    }

    public void addScript(String development, String testAndProduction) {
        this.addScript(development, testAndProduction, testAndProduction);
    }

    public void addScript(String allEnvironments) {
        this.addScript(allEnvironments, allEnvironments, allEnvironments);
    }

    public void suppressScript(String allEnvironments) {
        if (this.suppressedScripts == null) {
            this.suppressedScripts = new ArrayList<String>(4);
        }
        this.suppressedScripts.add(allEnvironments);
    }

    public List<String> getSuppressed(List<String> listToBuildUpon) {
        List<String> toRet = listToBuildUpon;
        if (this.suppressedScripts != null) {
            if (toRet == null) {
                toRet = new ArrayList<String>(this.suppressedScripts);
            } else {
                toRet.addAll(this.suppressedScripts);
            }
        }
        return toRet;
    }

    public void addSheet(String media, String development, String test, String production) {
        if (this.sheets == null) {
            this.sheets = new ArrayList<Sheet>(4);
        }
        Sheet toAdd = null;
        switch (this.environment) {
            case 0: {
                if (!StringHelper.isNonEmpty(development)) break;
                toAdd = new Sheet(media, development);
                break;
            }
            case 1: {
                if (!StringHelper.isNonEmpty(test)) break;
                toAdd = new Sheet(media, test);
                break;
            }
            default: {
                if (!StringHelper.isNonEmpty(production)) break;
                toAdd = new Sheet(media, production);
            }
        }
        if (toAdd != null && !this.sheets.contains(toAdd)) {
            this.sheets.add(toAdd);
        }
    }

    public void addSheet(String development, String test, String production) {
        this.addSheet(null, development, test, production);
    }

    public void addSheet(String development, String testAndProduction) {
        this.addSheet(null, development, testAndProduction, testAndProduction);
    }

    public void addSheet(String allEnvironments) {
        this.addSheet(null, allEnvironments, allEnvironments, allEnvironments);
    }

    public void suppressSheet(String allEnvironments) {
        if (this.suppressedSheets == null) {
            this.suppressedSheets = new ArrayList<String>(4);
        }
        this.suppressedSheets.add(allEnvironments);
    }

    public List<String> getSuppressedSheets(List<String> listToBuildUpon) {
        List<String> toRet = listToBuildUpon;
        if (this.suppressedSheets != null) {
            if (toRet == null) {
                toRet = new ArrayList<String>(this.suppressedSheets);
            } else {
                toRet.addAll(this.suppressedSheets);
            }
        }
        return toRet;
    }

    public void setFavicon(String favIcon) {
        this.favIcon = favIcon;
    }

    public String renderFavicon(Context context) {
        if (this.favIcon == null) {
            return "";
        }
        return "<link rel=\"SHORTCUT ICON\" href=\"" + context.getInfrastructure().getImageUrl(this.favIcon, context) + "\" />";
    }

    public String renderScripts(Context context, List<String> suppressed) {
        if (this.scripts == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String script : this.scripts) {
            if (suppressed != null && suppressed.contains(script)) continue;
            sb.append("<script src=\"");
            sb.append(NetworkHelper.escapeStringForHtml(String.valueOf(context.getInfrastructure().getJavaScriptDirectory(context)) + script));
            sb.append("\"></script>");
        }
        return sb.toString();
    }

    public String renderScripts(Context context) {
        return this.renderScripts(context, null);
    }

    public String renderSheets(Context context, List<String> suppressed) {
        if (this.sheets == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Sheet sheet : this.sheets) {
            if (suppressed != null && suppressed.contains(sheet.name)) continue;
            sb.append("<link rel=\"stylesheet");
            if (StringHelper.endsWithIgnoreCase(sheet.name, ".less")) {
                sb.append("/less");
            }
            sb.append("\" ");
            if (sheet.media != null) {
                sb.append("media=\"" + sheet.media + "\" ");
            }
            sb.append("href=\"");
            sb.append(NetworkHelper.escapeStringForHtml(String.valueOf(context.getInfrastructure().getCssDirectory(context)) + sheet.name));
            sb.append("\" />");
        }
        return sb.toString();
    }

    public String renderSheets(Context context) {
        return this.renderSheets(context, null);
    }

    public static class Sheet {
        private String media;
        private String name;

        public Sheet(String media, String name) {
            this.media = media;
            this.name = name;
        }

        public boolean equals(Object obj) {
            return obj instanceof Sheet && this.name.equals(((Sheet)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

