/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.log;

import com.techempower.gemini.Context;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.session.Session;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.log.Log;

public class GeminiComponentLog
extends ComponentLog {
    private static final ThreadLocalContextInfo CONTEXT_INFO = new ThreadLocalContextInfo();

    public GeminiComponentLog(Log log, String componentCode) {
        super(log, componentCode);
    }

    private static String getContextInformation() {
        return CONTEXT_INFO.getStringValue();
    }

    public static void setContextInformation(Context context) {
        StringBuilder buffer = new StringBuilder();
        Session session = context.getSession(false);
        buffer.append(StringHelper.truncateAtEnd(session == null ? "none" : session.getId(), 4));
        buffer.append(" ");
        if (context.getRequestNumber() > 0L) {
            buffer.append("- ");
            buffer.append(context.getRequestNumber());
            buffer.append(" ");
        }
        PyxisSecurity security = context.getApplication().getSecurity();
        PyxisUser user = null;
        if (security != null) {
            user = security.getUser(context);
        }
        if (user != null) {
            buffer.append(user.getUserID());
            buffer.append(" ");
        } else {
            buffer.append("- ");
        }
        CONTEXT_INFO.setStringValue(buffer.toString());
    }

    public static void clearContextInformation() {
        CONTEXT_INFO.setStringValue("");
    }

    @Override
    public void log(String debugString, int debugLevel, Throwable exc) {
        super.log(String.valueOf(GeminiComponentLog.getContextInformation()) + debugString, debugLevel, exc);
    }

    @Override
    public void log(String debugString, Throwable exc) {
        super.log(String.valueOf(GeminiComponentLog.getContextInformation()) + debugString, exc);
    }

    @Override
    public void log(String logString, int debugLevel) {
        super.log(String.valueOf(GeminiComponentLog.getContextInformation()) + logString, debugLevel);
    }

    @Override
    public void log(String logString) {
        super.log(String.valueOf(GeminiComponentLog.getContextInformation()) + logString);
    }

    @Override
    public void assertion(boolean evalExpression, String debugString, int debugLevel) {
        super.assertion(evalExpression, String.valueOf(GeminiComponentLog.getContextInformation()) + debugString, debugLevel);
    }

    @Override
    public void assertion(boolean evalExpression, String debugString) {
        super.assertion(evalExpression, String.valueOf(GeminiComponentLog.getContextInformation()) + debugString);
    }

    private static class ThreadLocalContextInfo
    extends ThreadLocal<String> {
        private ThreadLocalContextInfo() {
        }

        @Override
        public String initialValue() {
            return "";
        }

        public String getStringValue() {
            return (String)super.get();
        }

        public void setStringValue(String s) {
            super.set(s);
        }
    }
}

