/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.monitor.MonitorSample;
import com.techempower.helper.StringHelper;

public class MonitorInterval {
    public static final int MAXIMUM_REQUEST_SIGNATURE_LENGTH = 500;
    private MonitorSample mostQueries;
    private MonitorSample mostQueryTime;
    private MonitorSample mostLogicTime;
    private MonitorSample mostRenderTime;
    private MonitorSample mostExceptions;
    private MonitorSample mostSpecialTime;
    private MonitorSample mostCpuTime;
    private int totalDispatches;
    private int totalQueries;
    private int totalLogicTime;
    private int totalRenderTime;
    private int totalQueryExceptions;
    private int totalQueryTime;
    private int totalSamples;
    private int totalSpecialTime;
    private int totalCpuTime;
    private long intervalStart;
    private long intervalEnd;

    public MonitorInterval(long intervalStart, long intervalEnd) {
        this.intervalStart = intervalStart;
        this.intervalEnd = intervalEnd;
    }

    public void process(MonitorSample sample, Context context) {
        ++this.totalSamples;
        this.totalDispatches += sample.getDispatches();
        this.totalQueries += sample.getQueries();
        this.totalLogicTime += sample.getLogicTime();
        this.totalRenderTime += sample.getRenderTime();
        this.totalQueryExceptions += sample.getQueryExceptions();
        this.totalQueryTime += sample.getQueryTime();
        this.totalSpecialTime += sample.getSpecialTime();
        this.totalCpuTime += sample.getTotalCpuTime();
        if (this.getWorstQueries() < sample.getQueries()) {
            this.mostQueries = sample;
        }
        if (this.getWorstQueryTime() < sample.getQueryTime()) {
            this.mostQueryTime = sample;
        }
        if (this.getWorstLogicTime() < sample.getLogicTime()) {
            this.mostLogicTime = sample;
        }
        if (this.getWorstRenderTime() < sample.getRenderTime()) {
            this.mostRenderTime = sample;
        }
        if (this.getWorstQueryExceptions() < sample.getQueryExceptions()) {
            this.mostExceptions = sample;
        }
        if (this.getWorstSpecialTime() < sample.getSpecialTime()) {
            this.mostSpecialTime = sample;
        }
        if (this.getWorstCpuTime() < sample.getTotalCpuTime()) {
            this.mostCpuTime = sample;
        }
        if (this.mostQueries == sample || this.mostQueryTime == sample || this.mostLogicTime == sample || this.mostRenderTime == sample || this.mostExceptions == sample || this.mostSpecialTime == sample || this.mostCpuTime == sample) {
            sample.setRequestSignature(StringHelper.truncateEllipsis(context.getRequestSignature(), 500));
        }
    }

    public long getIntervalStart() {
        return this.intervalStart;
    }

    public long getIntervalEnd() {
        return this.intervalEnd;
    }

    public int getSampleCount() {
        return this.totalSamples;
    }

    public int getAverageDispatches() {
        return this.totalDispatches / this.totalSamples;
    }

    public int getAverageQueries() {
        return this.totalQueries / this.totalSamples;
    }

    public int getAverageLogicTime() {
        return this.totalLogicTime / this.totalSamples;
    }

    public int getAverageRenderTime() {
        return this.totalRenderTime / this.totalSamples;
    }

    public int getAverageQueryExceptions() {
        return this.totalQueryExceptions / this.totalSamples;
    }

    public int getAverageQueryTime() {
        return this.totalQueryTime / this.totalSamples;
    }

    public int getAverageSpecialTime() {
        return this.totalSpecialTime / this.totalSamples;
    }

    public int getAverageCpuTime() {
        return this.totalCpuTime / this.totalSamples;
    }

    public int getAverageTotalTime() {
        return this.getAverageLogicTime() + this.getAverageRenderTime();
    }

    public MonitorSample getMostQueries() {
        return this.mostQueries;
    }

    public MonitorSample getMostQueryTime() {
        return this.mostQueryTime;
    }

    public MonitorSample getMostQueryExceptions() {
        return this.mostExceptions;
    }

    public MonitorSample getMostLogicTime() {
        return this.mostLogicTime;
    }

    public MonitorSample getMostRenderTime() {
        return this.mostRenderTime;
    }

    public MonitorSample getMostSpecialTime() {
        return this.mostSpecialTime;
    }

    public MonitorSample getMostCpuTime() {
        return this.mostCpuTime;
    }

    public int getWorstQueries() {
        return this.getMostQueries() != null ? this.getMostQueries().getQueries() : 0;
    }

    public int getWorstQueryTime() {
        return this.getMostQueryTime() != null ? this.getMostQueryTime().getQueryTime() : 0;
    }

    public int getWorstQueryExceptions() {
        return this.getMostQueryExceptions() != null ? this.getMostQueryExceptions().getQueryExceptions() : 0;
    }

    public int getWorstLogicTime() {
        return this.getMostLogicTime() != null ? this.getMostLogicTime().getLogicTime() : 0;
    }

    public int getWorstRenderTime() {
        return this.getMostRenderTime() != null ? this.getMostRenderTime().getRenderTime() : 0;
    }

    public int getWorstSpecialTime() {
        return this.getMostSpecialTime() != null ? this.getMostSpecialTime().getSpecialTime() : 0;
    }

    public int getWorstCpuTime() {
        return this.getMostCpuTime() != null ? this.getMostCpuTime().getTotalCpuTime() : 0;
    }
}

