/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor;

import com.techempower.gemini.Context;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.MonitorInterval;
import com.techempower.gemini.monitor.MonitorSample;
import java.util.concurrent.atomic.AtomicInteger;

public class MonitoredCommand
implements Comparable<MonitoredCommand> {
    public static final int PAST_INTERVALS = 100;
    private final GeminiMonitor monitor;
    private final String command;
    private final AtomicInteger requests = new AtomicInteger(0);
    private final AtomicInteger currentLoad = new AtomicInteger(0);
    private MonitorSample lastSample;
    private MonitorInterval[] recentHistory;

    public MonitoredCommand(GeminiMonitor monitor, String command) {
        this.monitor = monitor;
        this.command = command;
        this.recentHistory = new MonitorInterval[100];
    }

    public void process(MonitorSample sample, Context context) {
        this.lastSample = sample;
        this.requests.incrementAndGet();
        if (this.recentHistory[0] == null) {
            this.recentHistory[0] = new MonitorInterval(this.monitor.getPerfIntervalStart(), this.monitor.getPerfIntervalEnd());
        }
        this.recentHistory[0].process(sample, context);
    }

    public void adjustLoad(int adjustment) {
        this.currentLoad.addAndGet(adjustment);
    }

    public int getCurrentLoad() {
        return this.currentLoad.get();
    }

    public MonitorSample getLastSample() {
        return this.lastSample;
    }

    public MonitorInterval getCurrentInterval() {
        return this.recentHistory[0];
    }

    public int getRequestCount() {
        return this.requests.get();
    }

    public String getCommand() {
        return this.command;
    }

    public void push() {
        int i = this.recentHistory.length - 1;
        while (i > 0) {
            this.recentHistory[i] = this.recentHistory[i - 1];
            --i;
        }
        this.recentHistory[0] = null;
    }

    @Override
    public int compareTo(MonitoredCommand other) {
        if (this.getCommand() != null && other != null && other.getCommand() != null) {
            return this.getCommand().compareTo(other.getCommand());
        }
        return 0;
    }

    public MonitorInterval[] getHistory() {
        return this.recentHistory;
    }

    public String toString() {
        return "MC [" + this.command + "]";
    }
}

