/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor.cpupercentage;

public class PercentageSample
implements Comparable<PercentageSample> {
    public static final long NS_PER_MS = 1000000L;
    public static final int CENT = 100;
    public static final int SLOP_THRESHOLD_PERCENT = 105;
    private final String name;
    private final long id;
    private final long ms;
    private short usage;

    public PercentageSample(String threadName, long threadID, long cpuTimeNs) {
        this.name = threadName;
        this.id = threadID;
        this.ms = cpuTimeNs / 1000000L;
    }

    public void setUsage(PercentageSample previous, long timeDeltaBetweenSamples) {
        long threadMs = this.ms - previous.ms;
        if (threadMs > 0L && timeDeltaBetweenSamples > 0L) {
            this.usage = (short)(100L * threadMs / timeDeltaBetweenSamples);
            if (this.usage > 100 && this.usage < 105) {
                this.usage = (short)100;
            }
        } else {
            this.usage = 0;
        }
    }

    @Override
    public int compareTo(PercentageSample o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public long getMs() {
        return this.ms;
    }

    public short getUsage() {
        return this.usage;
    }

    public String toString() {
        return "ID " + this.getId() + " (" + this.getName() + ") " + this.getMs() + "ms total time; " + this.getUsage() + "% current usage";
    }
}

