/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor.health;

import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.health.HealthSnapshotDetail;

public class HealthSnapshot {
    private final long startTime = System.currentTimeMillis();
    private long endTime;
    private long totalMemory;
    private long freeMemory;
    private long requestCount;
    private int dispatchCount;
    private int dispatchConcurrency;
    private int pageRenderCount;
    private int pageRenderConcurrency;
    private int queryCount;
    private int queryConcurrency;
    private int totalThreads;
    private int blockedThreads;
    private int waitingThreads;
    private boolean exceptional = false;
    private HealthSnapshotDetail detail = null;

    public HealthSnapshot(long intervalLength) {
        this.endTime = this.startTime + intervalLength;
    }

    public void complete(GeminiMonitor monitor) {
        this.requestCount = monitor.getRequestCount();
        this.dispatchConcurrency = monitor.getDispatchLoad();
        this.pageRenderConcurrency = monitor.getPageRenderLoad();
        this.queryConcurrency = monitor.getQueryLoad();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        this.freeMemory = Runtime.getRuntime().freeMemory();
        Thread[] threads = monitor.getThreadArray();
        int i = 0;
        while (i < threads.length) {
            if (threads[i] != null) {
                ++this.totalThreads;
                switch (threads[i].getState()) {
                    case BLOCKED: {
                        ++this.blockedThreads;
                        break;
                    }
                    case WAITING: {
                        ++this.waitingThreads;
                        break;
                    }
                }
            }
            ++i;
        }
        String evaluation = monitor.evaluateHealthSnapshot(this);
        if (evaluation != null) {
            this.exceptional = true;
            this.detail = new HealthSnapshotDetail();
            this.detail.setEvaluation(evaluation);
            this.detail.setThreadInfo(monitor.getThreadDetails());
        }
    }

    public boolean isExceptional() {
        return this.exceptional;
    }

    public String getEvaluationString() {
        if (this.exceptional && this.detail != null) {
            return this.detail.getEvaluation();
        }
        return null;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public void incrementDispatchCount() {
        ++this.dispatchCount;
    }

    public int getDispatchCount() {
        return this.dispatchCount;
    }

    public int getDispatchConcurrency() {
        return this.dispatchConcurrency;
    }

    public void incrementPageRenderCount() {
        ++this.pageRenderCount;
    }

    public int getPageRenderCount() {
        return this.pageRenderCount;
    }

    public int getPageRenderConcurrency() {
        return this.pageRenderConcurrency;
    }

    public void incrementQueryCount() {
        ++this.queryCount;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public int getQueryConcurrency() {
        return this.queryConcurrency;
    }

    public int getTotalThreads() {
        return this.totalThreads;
    }

    public int getBlockedThreads() {
        return this.blockedThreads;
    }

    public int getWaitingThreads() {
        return this.waitingThreads;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

