/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor.listener;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.monitor.GeminiMonitorListener;
import com.techempower.gemini.monitor.cpupercentage.PercentageInterval;
import com.techempower.gemini.monitor.health.HealthSnapshot;
import com.techempower.gemini.monitor.listener.MonitorListenerHelper;
import com.techempower.helper.DateHelper;
import com.techempower.log.ComponentLog;
import com.techempower.text.SynchronizedSimpleDateFormat;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;

public class BasicGeminiMonitorListener
implements GeminiMonitorListener,
Configurable {
    public static final SynchronizedSimpleDateFormat DATE_FORMAT = new SynchronizedSimpleDateFormat("yyyy-MM-dd-HH-mm-ss.SSS");
    public static final String CONFIGURATION_PREFIX = "SimpleGeminiMonitorListener.";
    private final ComponentLog log;
    private String fsLocation;

    public BasicGeminiMonitorListener(GeminiApplication application) {
        this.log = application.getLog("bgml");
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void healthSnapshotExceptional(HealthSnapshot snapshot) {
        Calendar now = DateHelper.getCalendarInstance();
        StringBuilder alert = new StringBuilder();
        alert.append(this.getStandardHeader("Health Exception", now));
        alert.append(String.valueOf(snapshot.getEvaluationString()) + "\r\n" + "\r\n");
        alert.append(MonitorListenerHelper.renderHealthSnapshot(snapshot));
        this.writeAlert(alert.toString(), now);
    }

    @Override
    public void cpuUtilizationIntervalExceptional(PercentageInterval interval) {
        Calendar now = DateHelper.getCalendarInstance();
        StringBuilder alert = new StringBuilder();
        alert.append(this.getStandardHeader("CPU Utilization Exception", now));
        alert.append(MonitorListenerHelper.renderCpuUtilization(interval));
        this.writeAlert(alert.toString(), now);
    }

    protected void writeAlert(String content, Calendar now) {
        String filename = String.valueOf(this.fsLocation) + File.separator + "alert-" + DATE_FORMAT.format(now.getTime()) + ".txt";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileWriter fw = new FileWriter(filename);){
                fw.write(content);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioexc) {
            this.log.log("Could not write alert file: " + filename + " " + ioexc);
        }
    }

    protected String getStandardHeader(String type, Calendar now) {
        return "Gemini Monitor Alert - " + type + "\r\n" + DATE_FORMAT.format(now.getTime()) + "\r\n" + "\r\n";
    }

    @Override
    public void configure(EnhancedProperties props) {
        String loc = String.valueOf(props.getProperty("Servlet.ApplicationRoot")) + File.separator + "monitor-alerts";
        this.fsLocation = loc = props.getProperty("SimpleGeminiMonitorListener.Location", loc);
        File file = new File(loc);
        if (!file.mkdirs()) {
            this.log.log("Could not create directory: " + this.fsLocation);
        }
    }
}

