/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor.listener;

import com.techempower.gemini.monitor.cpupercentage.PercentageInterval;
import com.techempower.gemini.monitor.cpupercentage.PercentageSample;
import com.techempower.gemini.monitor.health.HealthSnapshot;
import com.techempower.helper.StringHelper;

public final class MonitorListenerHelper {
    public static String renderHealthSnapshot(HealthSnapshot snapshot) {
        StringBuilder alert = new StringBuilder();
        alert.append("Processing\r\n");
        alert.append("Request count:      " + snapshot.getRequestCount() + "\r\n");
        alert.append("Disp. concurrency:  " + snapshot.getDispatchConcurrency() + "\r\n");
        alert.append("Disp. count:        " + snapshot.getDispatchCount() + "\r\n");
        alert.append("Render concurrency: " + snapshot.getPageRenderConcurrency() + "\r\n");
        alert.append("Render count:       " + snapshot.getPageRenderCount() + "\r\n");
        alert.append("Query concurrency:  " + snapshot.getQueryConcurrency() + "\r\n");
        alert.append("Query count:        " + snapshot.getQueryCount() + "\r\n");
        alert.append("\r\nThreads\r\n");
        alert.append("Total:   " + snapshot.getTotalThreads() + "\r\n");
        alert.append("Blocked: " + snapshot.getBlockedThreads() + "\r\n");
        alert.append("Waiting: " + snapshot.getWaitingThreads() + "\r\n");
        alert.append("\r\nMemory\r\n");
        alert.append("Total:   " + snapshot.getTotalMemory() + "\r\n");
        alert.append("Free:    " + snapshot.getFreeMemory() + "\r\n");
        return alert.toString();
    }

    public static String renderCpuUtilization(PercentageInterval interval) {
        StringBuilder alert = new StringBuilder();
        alert.append(interval.getEvaluation());
        alert.append("Other threads:\r\n");
        for (PercentageSample sample : interval.getSamples()) {
            alert.append("ID" + StringHelper.padSpace(sample.getId(), 7) + " " + StringHelper.padArbitraryRight(' ', sample.getName(), 49) + StringHelper.padSpace(sample.getMs(), 10) + "ms total time " + StringHelper.padSpace(sample.getUsage(), 3) + "% current usage" + "\r\n");
        }
        return alert.toString();
    }

    private MonitorListenerHelper() {
    }
}

