/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor.listener;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.notification.BasicNotification;
import com.techempower.gemini.admin.notification.Notification;
import com.techempower.gemini.monitor.GeminiMonitorListener;
import com.techempower.gemini.monitor.cpupercentage.PercentageInterval;
import com.techempower.gemini.monitor.health.HealthSnapshot;
import com.techempower.gemini.monitor.listener.MonitorListenerHelper;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;

public class NotificationGeminiMonitorListener
implements GeminiMonitorListener,
Configurable {
    public static final String SOURCE = "Monitor";
    private final GeminiApplication application;

    public NotificationGeminiMonitorListener(GeminiApplication application) {
        this.application = application;
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
    }

    @Override
    public void healthSnapshotExceptional(HealthSnapshot snapshot) {
        String synopsis = "Health - " + snapshot.getEvaluationString();
        String details = MonitorListenerHelper.renderHealthSnapshot(snapshot);
        this.sendNotification(synopsis, details, Notification.Severity.HIGH);
    }

    @Override
    public void cpuUtilizationIntervalExceptional(PercentageInterval interval) {
        String synopsis = "CPU Utilization - " + interval.getEvaluation();
        String details = MonitorListenerHelper.renderCpuUtilization(interval);
        this.sendNotification(synopsis, details, Notification.Severity.MEDIUM);
    }

    protected void sendNotification(String synopsis, String details, Notification.Severity severity) {
        BasicNotification n = new BasicNotification(SOURCE, synopsis, details, severity);
        this.application.getNotifier().addNotification(n);
    }
}

