/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor.session;

import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionState
implements HttpSessionListener,
Configurable {
    private final GeminiMonitor monitor;
    private int sessionCount;
    private boolean sessionTracking = false;
    private final Set<HttpSession> sessionSet;
    private int peakSessions = 0;

    public SessionState(GeminiMonitor monitor) {
        this.monitor = monitor;
        this.monitor.getApplication().getConfigurator().addConfigurable(this);
        this.sessionSet = new HashSet<HttpSession>();
        this.sessionCount = 0;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public synchronized Set<HttpSession> getSessions() {
        if (this.sessionTracking && this.sessionSet != null) {
            return new HashSet<HttpSession>(this.sessionSet);
        }
        return null;
    }

    public int getPeakSessions() {
        return this.peakSessions;
    }

    public synchronized void sessionCreated(HttpSessionEvent evt) {
        if (this.monitor.isSessionEnabled()) {
            ++this.sessionCount;
            if (this.sessionCount > this.peakSessions) {
                this.peakSessions = this.sessionCount;
            }
            if (this.sessionTracking) {
                this.sessionSet.add(evt.getSession());
                this.sessionCount = this.sessionSet.size();
            }
        }
    }

    public synchronized void sessionDestroyed(HttpSessionEvent evt) {
        if (this.monitor.isSessionEnabled()) {
            --this.sessionCount;
            if (this.sessionTracking) {
                this.sessionSet.remove(evt.getSession());
                this.sessionCount = this.sessionSet.size();
            }
            if (this.sessionCount < 0) {
                this.sessionCount = 0;
            }
        }
    }

    @Override
    public synchronized void configure(EnhancedProperties props) {
        this.sessionTracking = props.getYesNoProperty("GeminiMonitor.SessionTracking", false);
        if (!this.sessionTracking) {
            this.sessionSet.clear();
        }
    }
}

