/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.configuration.ConfigurationError;
import com.techempower.gemini.mustache.TemplateAppReferences;
import com.techempower.gemini.mustache.TemplateReferences;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class MustacheManager
implements Configurable {
    public static final String DEFAULT_MUSTACHE_EXTENSION = ".mustache";
    private final GeminiApplication application;
    private final TemplateAppReferences applicationReferences;
    private MustacheFactory mustacheFactory;
    private String mustacheDirectory;
    private boolean enabled;

    public MustacheManager(GeminiApplication application) {
        this.application = application;
        this.application.getConfigurator().addConfigurable(this);
        this.applicationReferences = this.constructApplicationReferences();
        application.getConfigurator().addConfigurable(this.applicationReferences);
    }

    protected TemplateAppReferences constructApplicationReferences() {
        return new TemplateAppReferences(this.application);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.enabled = props.getYesNoProperty("Mustache.Enabled", true);
        this.mustacheDirectory = props.getProperty("MustacheDirectory", "${Servlet.WebInf}/mustache/");
        if (this.enabled) {
            File directory = new File(this.mustacheDirectory);
            if (!directory.isDirectory()) {
                throw new ConfigurationError("MustacheDirectory " + this.mustacheDirectory + " does not exist.");
            }
            this.mustacheFactory = new DefaultMustacheFactory(new File(this.mustacheDirectory));
        }
    }

    public TemplateReferences getTemplateReferences(Context context, Object requestScope) {
        return new TemplateReferences(context, this.applicationReferences, requestScope);
    }

    protected TemplateAppReferences getApplicationReferences() {
        return this.applicationReferences;
    }

    protected MustacheFactory getMustacheFactory() {
        return this.application.getVersion().isDevelopment() ? new DefaultMustacheFactory(new File(this.mustacheDirectory)) : this.mustacheFactory;
    }

    public void render(String filename, Writer writer, Object ... scope) {
        if (filename == null || writer == null || scope == null) {
            throw new IllegalArgumentException("MustacheManager.render received at least one null argument: " + filename + " " + writer + " " + scope);
        }
        Mustache mustache = this.getMustacheFactory().compile(filename);
        mustache.execute(writer, scope);
    }

    public boolean render(String filename, Context context, Object scope) {
        try {
            PrintWriter writer = context.getWriter();
            TemplateReferences refs = this.getTemplateReferences(context, scope);
            this.render(filename, writer, refs);
            return true;
        }
        catch (IOException ioexc) {
            return false;
        }
    }
}

