/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.mustache;

import com.techempower.Version;
import com.techempower.gemini.BasicInfrastructure;
import com.techempower.gemini.GeminiApplication;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.HashMap;
import java.util.Map;

public class TemplateAppReferences
implements Configurable {
    public final GeminiApplication application;
    public final Map<Object, Object> env;
    public final Map<Object, String> path;

    public TemplateAppReferences(GeminiApplication application) {
        this.application = application;
        this.env = new HashMap<Object, Object>();
        this.path = new HashMap<Object, String>();
    }

    @Override
    public void configure(EnhancedProperties props) {
        Version version = this.application.getVersion();
        this.env.clear();
        this.env.putAll(version.getEnvironmentFlags());
        this.env.put("name", version.getProductName());
        this.env.put("descriptor", version.getDeploymentDescription());
        this.env.put("version", version.getVersionString());
        this.path.clear();
        BasicInfrastructure inf = this.application.getInfrastructure();
        this.path.put("img", inf.getImageDirectory());
        this.path.put("css", inf.getCssDirectory());
        this.path.put("js", inf.getJavaScriptDirectory());
        this.path.put("server", inf.getServerName());
        this.path.put("relative", inf.getUrl());
        this.path.put("absolute", inf.getStandardDomain());
        this.path.put("secure", inf.getSecureDomain());
    }
}

