/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.path;

import com.techempower.cache.EntityStore;
import com.techempower.collection.ImmutableNamedValues;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.context.Attachments;
import com.techempower.gemini.context.Cookies;
import com.techempower.gemini.context.Delivery;
import com.techempower.gemini.context.Headers;
import com.techempower.gemini.context.Messages;
import com.techempower.gemini.context.Query;
import com.techempower.gemini.context.SessionNamedValues;
import com.techempower.gemini.mustache.MustacheManager;
import com.techempower.gemini.path.PathHandler;
import com.techempower.gemini.path.PathSegments;
import com.techempower.gemini.path.UriAware;
import com.techempower.helper.StringHelper;
import com.techempower.js.JavaScriptWriter;
import com.techempower.log.ComponentLog;
import java.util.Collections;
import java.util.Map;

public abstract class BasicPathHandler<C extends Context>
implements PathHandler<C>,
UriAware {
    private final GeminiApplication application;
    private final ThreadLocal<References<C>> references;
    private final EntityStore store;
    private final JavaScriptWriter javaScriptWriter;
    private final MustacheManager mustacheManager;
    private final ComponentLog log;
    private String baseUri;

    public BasicPathHandler(GeminiApplication app, String componentCode, JavaScriptWriter jsw) {
        this.application = app;
        this.references = new ThreadLocal();
        this.mustacheManager = app.getMustacheManager();
        this.javaScriptWriter = jsw != null ? jsw : app.getJavaScriptWriter();
        this.store = app.getStore();
        this.log = app.getLog(componentCode);
    }

    public BasicPathHandler(GeminiApplication app, String componentCode) {
        this(app, componentCode, null);
    }

    public BasicPathHandler(GeminiApplication app) {
        this(app, "hdlr", null);
    }

    @Override
    public boolean prehandle(PathSegments segments, C context) {
        this.references.set(new References<C>(context, segments));
        return false;
    }

    @Override
    public void posthandle(PathSegments segments, C context) {
        this.references.remove();
    }

    @Override
    public abstract boolean handle(PathSegments var1, C var2);

    @Override
    public void setBaseUri(String uri) {
        this.baseUri = uri;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public C context() {
        return (C)((Context)this.references.get().context);
    }

    public PathSegments segments() {
        return this.references.get().segments;
    }

    public ImmutableNamedValues args() {
        return this.segments().getArguments();
    }

    public Query query() {
        return ((Context)this.context()).query();
    }

    public Messages messages() {
        return ((Context)this.context()).messages();
    }

    public SessionNamedValues session() {
        return ((Context)this.context()).session();
    }

    public Delivery delivery() {
        return ((Context)this.context()).delivery();
    }

    public Cookies cookies() {
        return ((Context)this.context()).cookies();
    }

    public Headers headers() {
        return ((Context)this.context()).headers();
    }

    public Attachments files() {
        return ((Context)this.context()).files();
    }

    public String template() {
        return this.references.get().template;
    }

    public BasicPathHandler<C> template(String name) {
        this.references.get().template = name;
        return this;
    }

    protected ComponentLog log() {
        return this.log;
    }

    @Deprecated
    protected ComponentLog getLog() {
        return this.getLog();
    }

    protected GeminiApplication app() {
        return this.application;
    }

    protected EntityStore store() {
        return this.store;
    }

    @Deprecated
    protected GeminiApplication getApplication() {
        return this.app();
    }

    protected void l(String toLog) {
        this.log.log(toLog);
    }

    protected void l(String toLog, int debugLevel) {
        this.log.log(toLog, debugLevel);
    }

    protected void l(String toLog, int debugLevel, Throwable throwable) {
        this.log.log(toLog, debugLevel, throwable);
    }

    public boolean message(String message) {
        return this.render(Collections.singletonMap("message", message));
    }

    public boolean error(int httpStatusCode, String errorMessage) {
        return this.error(httpStatusCode, Collections.singletonMap("error", errorMessage));
    }

    public boolean error(int httpStatusCode, Map<String, String> response) {
        ((Context)this.context()).setStatus(httpStatusCode);
        return this.render(response);
    }

    public boolean badHttpMethod(String errorMessage) {
        return this.error(405, errorMessage);
    }

    public boolean badHttpMethod(Map<String, String> response) {
        return this.error(405, response);
    }

    public boolean badRequest(String errorMessage) {
        return this.error(400, errorMessage);
    }

    public boolean badRequest(Map<String, String> response) {
        return this.error(400, response);
    }

    public boolean unauthorized(String errorMessage) {
        return this.error(401, errorMessage);
    }

    public boolean unauthorized(Map<String, String> response) {
        return this.error(401, response);
    }

    public boolean notFound(String errorMessage) {
        return this.error(404, errorMessage);
    }

    public boolean notFound(Map<String, String> response) {
        return this.error(404, response);
    }

    public boolean redirect(String url) {
        return ((Context)this.context()).redirect(url);
    }

    public boolean redirectRelative(String uri) {
        boolean initialSlash = uri.length() > 0 && uri.charAt(0) == '/';
        return ((Context)this.context()).redirect(String.valueOf(this.segments().getUriBelowOffset()) + (initialSlash ? "" : "/") + uri);
    }

    public boolean render(Object object) {
        String template = this.references.get().template;
        if (StringHelper.isEmpty(template) || this.mustacheManager == null || GeminiHelper.isJsonRequest(this.context())) {
            return this.json(object);
        }
        return this.mustache(template, object);
    }

    public boolean render() {
        return this.render(((Context)this.context()).delivery().getMap());
    }

    public boolean json(Object object) {
        return GeminiHelper.sendJson(this.context(), object, this.javaScriptWriter);
    }

    public boolean text(String text) {
        return GeminiHelper.sendPlaintext(this.context(), text);
    }

    public boolean mustache(String template) {
        return this.mustache(template, ((Context)this.context()).delivery().getMap());
    }

    public boolean mustache(String template, Object object) {
        String filename = String.valueOf(template) + ".mustache";
        C context = this.context();
        this.application.getDispatcher().renderStarting((Context)context, template);
        try {
            boolean bl = this.mustacheManager.render(filename, (Context)context, object);
            return bl;
        }
        finally {
            this.application.getDispatcher().renderComplete((Context)context);
        }
    }

    public static class References<C> {
        public final C context;
        public final PathSegments segments;
        public String template;

        public References(C context, PathSegments segments) {
            this.context = context;
            this.segments = segments;
        }
    }
}

