/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.path;

import com.techempower.gemini.Context;
import com.techempower.gemini.path.PathHandler;
import com.techempower.gemini.path.PathSegments;
import com.techempower.gemini.path.UriAware;
import java.util.HashMap;
import java.util.Map;

public class DispatchSegment<C extends Context>
implements PathHandler<C>,
UriAware {
    protected final Map<String, MappedHandler<C>> handlers;
    protected final String capturedArgumentName;
    protected final MappedHandler<C> defaultHandler;
    protected String baseUri;

    public DispatchSegment() {
        this.handlers = new HashMap<String, MappedHandler<C>>(1);
        this.defaultHandler = null;
        this.capturedArgumentName = null;
    }

    protected DispatchSegment(Map<String, MappedHandler<C>> handlers, MappedHandler<C> defaultHandler) {
        this.handlers = new HashMap<String, MappedHandler<C>>(handlers.size() + 1);
        this.handlers.putAll(handlers);
        this.defaultHandler = defaultHandler;
        this.capturedArgumentName = null;
    }

    protected DispatchSegment(String argumentName, MappedHandler<C> nextHandler) {
        this.handlers = null;
        this.capturedArgumentName = argumentName;
        this.defaultHandler = nextHandler;
    }

    @Override
    public void setBaseUri(String uri) {
        this.baseUri = uri;
    }

    public DispatchSegment<C> add(String pathSegment, PathHandler<C> handler, String ... followingArgumentNames) {
        this.notifyOfBaseUri(handler, String.valueOf(this.baseUri) + "/" + pathSegment);
        DispatchSegment<C> toReturn = new DispatchSegment<C>(this.handlers, this.defaultHandler);
        toReturn.handlers.put(pathSegment, new MappedHandler<C>(handler, followingArgumentNames));
        return toReturn;
    }

    public DispatchSegment<C> arg(String argumentName, PathHandler<C> nextHandler) {
        DispatchSegment<C> toReturn = new DispatchSegment<C>(argumentName, new MappedHandler<C>(nextHandler, null));
        return toReturn;
    }

    public DispatchSegment<C> setDefault(PathHandler<C> defaultHandler, String ... followingArgumentNames) {
        this.notifyOfBaseUri(defaultHandler, this.baseUri);
        return new DispatchSegment<C>(this.handlers, new MappedHandler<C>(defaultHandler, followingArgumentNames));
    }

    protected void notifyOfBaseUri(PathHandler<C> handler, String uri) {
        if (handler instanceof UriAware) {
            UriAware uriAware = (UriAware)((Object)handler);
            uriAware.setBaseUri(uri);
        }
    }

    @Override
    public boolean prehandle(PathSegments segments, C context) {
        return false;
    }

    @Override
    public void posthandle(PathSegments segments, C context) {
    }

    @Override
    public boolean handle(PathSegments segments, C context) {
        MappedHandler<C> handlerToUse;
        String segment = segments.get(0);
        MappedHandler<C> mappedHandler = this.handlers != null ? this.handlers.get(segment) : null;
        MappedHandler<C> mappedHandler2 = handlerToUse = mappedHandler != null ? mappedHandler : this.defaultHandler;
        if (handlerToUse != null) {
            PathHandler<C> handler = handlerToUse.handler;
            if (this.capturedArgumentName != null) {
                segments.assignName(0, this.capturedArgumentName);
            }
            if (handlerToUse.followingArgumentNames != null) {
                int index = 1;
                String[] stringArray = handlerToUse.followingArgumentNames;
                int n = handlerToUse.followingArgumentNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    segments.assignName(index++, name);
                    ++n2;
                }
            }
            if (mappedHandler != null || this.capturedArgumentName != null) {
                segments.increaseOffset();
            }
            try {
                if (handler.prehandle(segments, context)) {
                    return true;
                }
                boolean bl = handler.handle(segments, context);
                return bl;
            }
            finally {
                try {
                    handler.posthandle(segments, context);
                }
                finally {
                    if (mappedHandler != null || this.capturedArgumentName != null) {
                        segments.decreaseOffset();
                    }
                }
            }
        }
        return false;
    }

    static class MappedHandler<C extends Context> {
        final PathHandler<C> handler;
        final String[] followingArgumentNames;

        MappedHandler(PathHandler<C> hdlr, String[] argumentNames) {
            this.handler = hdlr;
            this.followingArgumentNames = argumentNames;
        }
    }
}

