/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.path;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.path.BasicPathHandler;
import com.techempower.gemini.path.PathSegments;
import com.techempower.gemini.path.annotation.PathDefault;
import com.techempower.gemini.path.annotation.PathRoot;
import com.techempower.gemini.path.annotation.PathSegment;
import com.techempower.helper.ReflectionHelper;
import com.techempower.helper.StringHelper;
import com.techempower.js.JavaScriptWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class MethodPathHandler<C extends Context>
extends BasicPathHandler<C> {
    private static final Class<?>[] CONTEXT_PARAMETER = new Class[]{Context.class};
    private final Map<String, PathSegmentMethod> annotatedHandleMethods = new HashMap<String, PathSegmentMethod>();
    private final MethodAccess methodAccess = MethodAccess.get(this.getClass());
    private final PathSegmentMethod defaultMethod = this.discoverAnnotatedMethods();

    public MethodPathHandler(GeminiApplication app, String componentCode, JavaScriptWriter jsw) {
        super(app, componentCode, jsw);
    }

    public MethodPathHandler(GeminiApplication app, String componentCode) {
        this(app, componentCode, null);
    }

    public MethodPathHandler(GeminiApplication app) {
        this(app, "hdlr", null);
    }

    private PathSegmentMethod discoverAnnotatedMethods() {
        Method[] methods = this.getClass().getDeclaredMethods();
        PathSegmentMethod toReturn = new PathSegmentMethod("", -1, false);
        PathSegmentMethod root = new PathSegmentMethod("", -1, false);
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            PathDefault pd;
            PathRoot pr;
            Method method = methodArray[n2];
            PathSegment ps = method.getAnnotation(PathSegment.class);
            if (ps != null) {
                String segment = StringHelper.isEmpty(ps.value()) ? method.getName() : ps.value();
                this.annotatedHandleMethods.put(segment, this.analyzeAnnotatedMethod(method));
            }
            if ((pr = method.getAnnotation(PathRoot.class)) != null) {
                if (root.index == -1) {
                    root = this.analyzeAnnotatedMethod(method);
                    this.annotatedHandleMethods.put("", root);
                } else {
                    throw new IllegalAccessError("More than one method has been annotated as @PathRoot. See " + method.getName());
                }
            }
            if ((pd = method.getAnnotation(PathDefault.class)) != null) {
                if (toReturn.index == -1) {
                    toReturn = this.analyzeAnnotatedMethod(method);
                } else {
                    throw new IllegalAccessError("More than one method has been annotated as @PathDefault. See " + method.getName());
                }
            }
            ++n2;
        }
        if (toReturn == null) {
            throw new IllegalArgumentException("Exactly one method must be annotated as @PathDefault; none were found.");
        }
        return toReturn;
    }

    protected PathSegmentMethod analyzeAnnotatedMethod(Method method) {
        if (Modifier.isPublic(method.getModifiers())) {
            if (method.getParameterTypes().length == 0) {
                return new PathSegmentMethod(method.getName(), this.methodAccess.getIndex(method.getName(), (Class[])ReflectionHelper.NO_PARAMETERS), false);
            }
            if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Context.class) {
                return new PathSegmentMethod(method.getName(), this.methodAccess.getIndex(method.getName(), (Class[])CONTEXT_PARAMETER), true);
            }
            throw new IllegalAccessError("Method " + method.getName() + " must take zero arguments or a single Context argument.");
        }
        throw new IllegalAccessError("Method " + method.getName() + " must be public to be annotated as a @PathSegment or @PathDefault.");
    }

    @Override
    public boolean handle(PathSegments segments, C context) {
        return this.dispatchToAnnotatedMethod(this.getAnnotatedMethod(segments), context);
    }

    protected PathSegmentMethod getAnnotatedMethod(PathSegments segments) {
        PathSegmentMethod method = this.annotatedHandleMethods.get(segments.get(0, ""));
        return method != null ? method : this.defaultMethod;
    }

    protected boolean dispatchToAnnotatedMethod(PathSegmentMethod method, C context) {
        if (method.index >= 0) {
            if (method.contextParameter) {
                return (Boolean)this.methodAccess.invoke((Object)this, method.index, new Object[]{context});
            }
            return (Boolean)this.methodAccess.invoke((Object)this, method.index, ReflectionHelper.NO_VALUES);
        }
        return false;
    }

    protected static class PathSegmentMethod {
        public final String name;
        public final int index;
        public final boolean contextParameter;

        public PathSegmentMethod(String name, int index, boolean contextParameter) {
            this.name = name;
            this.index = index;
            this.contextParameter = contextParameter;
        }
    }
}

