/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.path;

import com.techempower.collection.ImmutableNamedStrings;
import com.techempower.collection.ImmutableNamedValues;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;

public class PathSegments {
    private final String uri;
    private final String[] segments;
    private int offset = 0;
    private ImmutableNamedStrings namedSegments;

    public PathSegments(String uri) {
        this.uri = uri.length() > 1 && uri.charAt(0) == '/' ? uri.substring(1) : uri;
        this.segments = this.uri.split("/");
    }

    protected PathSegments offset(int newOffset) {
        this.offset = NumberHelper.boundInteger(newOffset, 0, this.segments.length);
        return this;
    }

    protected PathSegments increaseOffset() {
        ++this.offset;
        return this;
    }

    protected PathSegments decreaseOffset() {
        --this.offset;
        return this;
    }

    protected PathSegments assignName(int index, String name) {
        int assignIndex;
        if (this.namedSegments == null) {
            this.namedSegments = new ImmutableNamedStrings(Math.max(this.segments.length, 100));
        }
        if ((assignIndex = index + this.offset) >= 0 && assignIndex < this.segments.length) {
            this.namedSegments.put(name, this.segments[assignIndex]);
        }
        return this;
    }

    public ImmutableNamedValues getArguments() {
        if (this.namedSegments == null) {
            this.namedSegments = new ImmutableNamedStrings(0);
        }
        return this.namedSegments.seal();
    }

    public String getUri() {
        return this.uri;
    }

    public String getUriFromRoot() {
        return "/" + this.uri;
    }

    public String getUriBelowOffset() {
        if (this.offset == 0) {
            return "/";
        }
        StringBuilder toReturn = new StringBuilder(this.uri.length() + 1);
        int i = 0;
        while (i < this.offset) {
            toReturn.append('/');
            toReturn.append(this.segments[i]);
            ++i;
        }
        return toReturn.toString();
    }

    public int getCount() {
        return this.segments.length - this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public String get(int index) {
        int getIndex = index + this.offset;
        if (getIndex >= 0 && getIndex < this.segments.length) {
            return this.segments[getIndex];
        }
        return null;
    }

    public String get(int index, String defaultValue) {
        String rawValue = this.get(index);
        return rawValue == null ? defaultValue : rawValue;
    }

    public int getInt(int index, int defaultValue) {
        return NumberHelper.parseInt(this.get(index), defaultValue);
    }

    public int getInt(int index) {
        return this.getInt(index, 0);
    }

    public String toString() {
        return "PathSegments [" + StringHelper.join(" / ", this.segments) + "]";
    }
}

