/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis;

import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.Handler;
import com.techempower.gemini.LegacyContext;
import com.techempower.gemini.form.BasicForm;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormCheckBox;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormHidden;
import com.techempower.gemini.form.FormPasswordField;
import com.techempower.gemini.form.FormSubmitButton;
import com.techempower.gemini.form.FormTextField;
import com.techempower.gemini.form.FormValidation;
import com.techempower.gemini.pyxis.LoginTokenManager;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class BasicLoginHandler<D extends BasicDispatcher, C extends LegacyContext>
implements Handler<D, C>,
Configurable {
    public static final String COMPONENT_CODE = "hLog";
    public static final String SO_PRIOR_URL = "PriorURL";
    public static final String SO_TEMP_PRIOR_REQUEST = "TemporaryPriorRequest";
    public static final String CMD_INDIRECT_LOGIN = "lh-indirect-login";
    public static final String SO_COOKIE_LOGIN = "UserDidCookieLogin";
    public static final int DEFAULT_FAILED_RESET_SECONDS = 300;
    private final GeminiApplication application;
    private final ComponentLog log;
    private final String propsPrefix;
    private final PyxisSecurity security;
    private final LoginTokenManager loginTokenManager;
    private String cmdLogin = "login";
    private String cmdLogout = "logout";
    private String jspLogin = "login.jsp";
    private String jspLogout = "logout.jsp";
    private String cmdPostLogin = "home";
    private boolean allowPasswordReset = true;
    private boolean cookieLoginEnabled = true;
    private boolean cookieLoginSslOnly = true;
    private boolean logoutDeletesCookie = false;
    private boolean requireHttpsForm = false;
    private boolean exitHttpsPostLogin = true;
    private int failedAttemptLimit = 0;
    private int failedResetSeconds = 300;
    private long nextAutoReset = 0L;
    private String redirectPostLoginUrl = null;
    private boolean capturePosts = false;
    private Map<String, LoginAttempt> ipToAttempts = null;
    private boolean useJson = true;

    public BasicLoginHandler(GeminiApplication application, String propsPrefix) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.propsPrefix = StringHelper.isNonEmpty(propsPrefix) ? propsPrefix : "LoginHandler.";
        application.getConfigurator().addConfigurable(this);
        this.security = this.application.getSecurity();
        if (this.security == null) {
            this.log.debug("Error: Application does not provide a security manager!", 90);
        }
        this.loginTokenManager = new LoginTokenManager(application);
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    protected PyxisSecurity getSecurity() {
        return this.security;
    }

    @Override
    public String getDescription() {
        return "Reusable generic login handler";
    }

    @Override
    public int getPriority() {
        return -1000;
    }

    protected boolean handleLogout(D dispatcher, C context, String command) {
        if (this.application.getSecurity().isLoggedIn((Context)context)) {
            this.application.getSecurity().logout((Context)context);
            ((Context)context).session().remove(SO_COOKIE_LOGIN);
            if (this.logoutDeletesCookie) {
                this.log.debug("Deleting automatic login cookie.", 0);
                this.removeAutomaticLoginCookie((Context)context);
            }
            return this.handlePostLogout(dispatcher, context, command);
        }
        return this.handleLogoutNoUser(dispatcher, context, command);
    }

    protected boolean handleLogin(D dispatcher, C context, String command) {
        if (!this.security.isLoggedIn((Context)context) && this.cookieLogin(dispatcher, context, command)) {
            return true;
        }
        if (!this.isCommandDirectLogin(command)) {
            int cmdIndex;
            if (this.useJson && GeminiHelper.isJsonRequest(context)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("login", ((LegacyContext)context).getCmdURL(this.getLoginCommand()));
                map.put("message", "You need to be logged in to perform this action. Please login and try again.");
                ((Context)context).setStatus(401);
                return GeminiHelper.sendJson(context, map);
            }
            if (((Context)context).delivery().has(SO_PRIOR_URL)) {
                ((Context)context).session().putObject(String.valueOf(this.propsPrefix) + SO_PRIOR_URL, ((Context)context).delivery().get(SO_PRIOR_URL));
            } else {
                ((Context)context).session().putObject(String.valueOf(this.propsPrefix) + SO_PRIOR_URL, ((Context)context).getRequestSignature());
                if (this.capturePosts) {
                    ((Context)context).session().putObject(SO_TEMP_PRIOR_REQUEST, ((Context)context).getRequest());
                }
            }
            ((Context)context).delivery().put("Indirect", true);
            String url = ((LegacyContext)context).getCmdURL(this.getLoginCommand());
            String queryString = ((Context)context).getQueryString();
            if (queryString == null) {
                queryString = "";
            }
            queryString = (cmdIndex = queryString.indexOf("cmd")) >= 0 ? queryString.replace("cmd=", "referrer-cmd=") : String.valueOf(queryString) + "referrer-cmd=" + command;
            url = url.contains("?") ? String.valueOf(url) + "&" + queryString : String.valueOf(url) + "?" + queryString;
            return ((Context)context).redirect(url);
        }
        ((Context)context).delivery().put("Indirect", false);
        Form form = this.buildForm((Context)context);
        ((Context)context).delivery().putObject(this.getFormDeliveryName(), form);
        if (form.hasBeenSubmitted((Context)context)) {
            FormValidation formValidation = form.validate((Context)context);
            Object usernameField = form.getElement("lhuser");
            Object passwordField = form.getElement("lhpass");
            String username = ((FormElement)usernameField).getStringValue().toLowerCase();
            if (formValidation.isGood() && this.performCustomValidation(dispatcher, context, command, form)) {
                String password = form.getStringValue("lhpass");
                boolean saveCookie = ((FormCheckBox)form.getElement("lhremember")).isChecked();
                boolean success = this.canAttemptLogin((Context)context);
                if (success) {
                    success = this.security.login((Context)context, username, password);
                } else {
                    this.log.debug("Too many attempts from " + ((Context)context).getClientID() + "; blocked temporarily.");
                }
                if (success) {
                    this.successfulLoginAttempt((Context)context);
                    if (saveCookie && this.isCookieLoginPermitted((Context)context)) {
                        this.loginTokenManager.createAndPersistToken((Context)context, username);
                    }
                    this.postLoginProcessing(context);
                    PyxisUser user = this.security.getUser((Context)context);
                    String redirectURL = ((Context)context).session().get(String.valueOf(this.propsPrefix) + SO_PRIOR_URL);
                    ((Context)context).session().remove(String.valueOf(this.propsPrefix) + SO_PRIOR_URL);
                    if (this.capturePosts && ((Context)context).session().has(SO_TEMP_PRIOR_REQUEST)) {
                        ((Context)context).session().putObject("_consumable_prior_request", ((Context)context).session().getObject(SO_TEMP_PRIOR_REQUEST)).remove(SO_TEMP_PRIOR_REQUEST);
                    }
                    redirectURL = StringHelper.isNonEmpty(redirectURL) ? ((LegacyContext)context).encodeURL(redirectURL) : (this.redirectPostLoginUrl != null ? this.redirectPostLoginUrl : ((LegacyContext)context).getCmdURL(this.getPostLoginCommand()));
                    if (this.useJson && GeminiHelper.isJsonRequest(context)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("status", "ok");
                        return GeminiHelper.sendJson(context, map);
                    }
                    this.log.debug("Login [" + user.getUserUsername() + "]; redirecting: " + redirectURL);
                    return ((Context)context).redirect(redirectURL);
                }
                this.failedLoginAttempt((Context)context);
                ((FormElement)passwordField).setValue("");
                ((Context)context).delivery().put("message", "Invalid login.  Please try again.");
                return this.handleInvalidLogin(dispatcher, context, command);
            }
            ((Context)context).delivery().putObject(this.getFormValidationDeliveryName(), formValidation);
        } else {
            this.preLoginProcessing(context, form);
        }
        return ((LegacyContext)context).render(this.getLoginPage());
    }

    protected boolean cookieLogin(D dispatcher, C context, String command) {
        if (this.isCookieLoginPermitted((Context)context)) {
            LoginTokenManager.TokenValidation validation;
            try {
                validation = this.loginTokenManager.validateAndUpdateToken((Context)context);
            }
            catch (SQLException e) {
                this.log.debug("SQL exception while validating and updating token.", 70, e);
                return false;
            }
            if (validation.isValid()) {
                PyxisUser user;
                boolean success = this.canAttemptLogin((Context)context);
                if (success) {
                    user = this.security.getUser(validation.getUsername());
                    success = this.security.login((Context)context, user);
                } else {
                    this.log.debug("Too many attempts from " + ((Context)context).getClientID() + "; blocked temporarily.");
                }
                if (success) {
                    this.successfulLoginAttempt((Context)context);
                    ((Context)context).session().put(SO_COOKIE_LOGIN, true);
                    this.postLoginProcessing(context);
                    user = this.security.getUser((Context)context);
                    if (((Context)context).delivery().has(SO_PRIOR_URL)) {
                        this.log.debug("Cookie login [" + user.getUserUsername() + "]; redirecting: " + ((Context)context).delivery().get(SO_PRIOR_URL));
                        return ((Context)context).redirect(((Context)context).delivery().get(SO_PRIOR_URL));
                    }
                    String newCommand = command;
                    if (command == null || this.getLoginCommand().equalsIgnoreCase(command)) {
                        newCommand = this.getPostLoginCommand();
                    }
                    this.log.debug("Cookie login [" + user.getUserUsername() + "]; redispatching: " + command);
                    return ((BasicDispatcher)dispatcher).redispatch((Context)context, newCommand);
                }
                this.failedLoginAttempt((Context)context);
            }
        }
        return false;
    }

    protected Form buildForm(Context context) {
        String location;
        if (this.requireHttpsOnForm()) {
            location = context.getSecureUrl();
            context.delivery().put("SecureForm", true);
        } else {
            location = context.getUrl();
            context.delivery().put("SecureForm", false);
        }
        BasicForm form = new BasicForm(this.application, "LoginForm", location, "post");
        form.add(new FormHidden("cmd", this.getLoginCommand(), true));
        FormTextField lhuser = new FormTextField("lhuser", true, 100, 100);
        lhuser.setDisplayName("User name");
        form.add(lhuser);
        FormPasswordField lhpass = new FormPasswordField("lhpass", "", true, 30, 30);
        lhpass.setDisplayName("Password");
        form.add(lhpass);
        FormCheckBox lhremember = new FormCheckBox("lhremember", "", false, false);
        lhremember.setDisplayName("Remember me");
        form.add(lhremember);
        if (this.allowPasswordReset) {
            FormCheckBox lhforgot = new FormCheckBox("lhforgot", "", false, false);
            lhforgot.setDisplayName("I forgot my password");
            form.add(lhforgot);
        }
        form.addSubmissionElement(new FormSubmitButton("lhlogin", " Login ", true));
        return form;
    }

    protected boolean canAttemptLogin(Context context) {
        if (this.isFailedAttemptLimiting()) {
            Map<String, LoginAttempt> map = this.getIpToAttempts();
            LoginAttempt attempt = map.get(context.getClientID());
            if (attempt == null) {
                return true;
            }
            return attempt.isGood();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failedLoginAttempt(Context context) {
        if (this.isFailedAttemptLimiting()) {
            LoginAttempt attempt;
            Map<String, LoginAttempt> map;
            Map<String, LoginAttempt> map2 = map = this.getIpToAttempts();
            synchronized (map2) {
                attempt = map.get(context.getClientID());
                if (attempt == null) {
                    attempt = new LoginAttempt();
                    map.put(context.getClientID(), attempt);
                }
            }
            attempt.attempt();
        }
    }

    protected void successfulLoginAttempt(Context context) {
        if (this.isFailedAttemptLimiting()) {
            Map<String, LoginAttempt> map = this.getIpToAttempts();
            map.remove(context.getClientID());
        }
    }

    protected boolean isCookieLoginPermitted(Context context) {
        return this.isCookieLoginEnabled() && (!this.isCookieLoginSslOnly() || context.isSecure());
    }

    @Override
    public boolean acceptRequest(D dispatcher, C context, String command) {
        if (this.security != null) {
            if (command.equalsIgnoreCase(this.getLoginCommand()) || command.equalsIgnoreCase(this.getLogoutCommand())) {
                return true;
            }
        } else {
            this.log.debug("Error: LoginHandler cannot function without a security manager.");
        }
        return false;
    }

    @Override
    public boolean handleRequest(D dispatcher, C context, String command) {
        if (StringHelper.isNonEmpty(command) && command.equalsIgnoreCase(this.getLogoutCommand())) {
            return this.handleLogout(dispatcher, context, command);
        }
        return this.handleLogin(dispatcher, context, command);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.cmdLogin = props.getProperty(String.valueOf(this.propsPrefix) + "CmdLogin", this.cmdLogin);
        this.cmdLogout = props.getProperty(String.valueOf(this.propsPrefix) + "CmdLogout", this.cmdLogout);
        this.cmdPostLogin = props.getProperty(String.valueOf(this.propsPrefix) + "CmdPostLogin", this.cmdPostLogin);
        this.jspLogin = props.getProperty(String.valueOf(this.propsPrefix) + "JspLogin", this.jspLogin);
        this.jspLogout = props.getProperty(String.valueOf(this.propsPrefix) + "JspLogout", this.jspLogout);
        this.setCookieLoginEnabled(props.getYesNoProperty(String.valueOf(this.propsPrefix) + "CookieLoginEnabled", this.isCookieLoginEnabled()));
        this.setCookieLoginSslOnly(props.getYesNoProperty(String.valueOf(this.propsPrefix) + "CookieLoginSSLOnly", this.isCookieLoginSslOnly()));
        this.logoutDeletesCookie = props.getYesNoProperty(String.valueOf(this.propsPrefix) + "LogoutDeletesCookie", this.logoutDeletesCookie);
        this.requireHttpsForm = props.getYesNoProperty(String.valueOf(this.propsPrefix) + "RequireHTTPS", this.requireHttpsForm);
        this.exitHttpsPostLogin = props.getYesNoProperty(String.valueOf(this.propsPrefix) + "ExitHTTPS", this.exitHttpsPostLogin);
        this.failedAttemptLimit = props.getIntegerProperty(String.valueOf(this.propsPrefix) + "FailedAttemptLimit", this.failedAttemptLimit);
        this.failedResetSeconds = props.getIntegerProperty(String.valueOf(this.propsPrefix) + "FailedResetSeconds", this.failedResetSeconds);
        this.redirectPostLoginUrl = props.getProperty(String.valueOf(this.propsPrefix) + "RedirectPostLoginUrl", this.redirectPostLoginUrl);
        this.allowPasswordReset = props.getYesNoProperty(String.valueOf(this.propsPrefix) + "AllowPasswordReset", this.allowPasswordReset);
        this.capturePosts = props.getYesNoProperty(String.valueOf(this.propsPrefix) + "CapturePosts", this.capturePosts);
        this.useJson = props.getYesNoProperty(String.valueOf(this.propsPrefix) + "UseJson", this.useJson);
        if (this.isFailedAttemptLimiting()) {
            this.nextAutoReset = DateHelper.getEndOfDay().getTime().getTime();
        }
    }

    public String getLoginCommand() {
        return this.cmdLogin;
    }

    public String getLogoutCommand() {
        return this.cmdLogout;
    }

    protected String getLoginPage() {
        return this.jspLogin;
    }

    public boolean isFailedAttemptLimiting() {
        return this.failedAttemptLimit > 0;
    }

    protected boolean handleLogoutNoUser(D dispatcher, C context, String command) {
        return false;
    }

    protected void removeAutomaticLoginCookie(Context context) {
        this.loginTokenManager.clearCookie(context);
    }

    protected boolean handlePostLogout(D dispatcher, C context, String command) {
        return ((LegacyContext)context).render(this.jspLogout);
    }

    protected void postLoginProcessing(C context) {
    }

    protected void preLoginProcessing(C context, Form loginForm) {
    }

    protected boolean isCommandDirectLogin(String command) {
        return StringHelper.isNonEmpty(command) && command.equalsIgnoreCase(this.getLoginCommand());
    }

    protected boolean handleInvalidLogin(D dispatcher, C context, String command) {
        return ((LegacyContext)context).render(this.getLoginPage());
    }

    protected boolean performCustomValidation(D dispatcher, C context, String command, Form loginForm) {
        return true;
    }

    public String getPostLoginCommand() {
        return this.cmdPostLogin;
    }

    protected boolean requireHttpsOnForm() {
        return this.requireHttpsForm;
    }

    protected boolean exitHttpsAfterLogin() {
        return this.exitHttpsPostLogin;
    }

    public boolean isCookieLoginEnabled() {
        return this.cookieLoginEnabled;
    }

    public void setCookieLoginEnabled(boolean cookieLoginEnabled) {
        this.cookieLoginEnabled = cookieLoginEnabled;
    }

    public boolean isCookieLoginSslOnly() {
        return this.cookieLoginSslOnly;
    }

    public void setCookieLoginSslOnly(boolean cookieLoginSslOnly) {
        this.cookieLoginSslOnly = cookieLoginSslOnly;
    }

    protected String getFormDeliveryName() {
        return "Form";
    }

    protected String getFormValidationDeliveryName() {
        return "FormValidation";
    }

    protected synchronized Map<String, LoginAttempt> getIpToAttempts() {
        this.autoResetAttemptsIfNeeded();
        if (this.ipToAttempts == null) {
            this.ipToAttempts = new HashMap<String, LoginAttempt>();
        }
        return this.ipToAttempts;
    }

    protected void autoResetAttemptsIfNeeded() {
        if (System.currentTimeMillis() > this.nextAutoReset) {
            this.resetLoginAttempts();
            this.nextAutoReset = DateHelper.getEndOfDay().getTime().getTime();
        }
    }

    protected synchronized void resetLoginAttempts() {
        this.ipToAttempts = null;
    }

    protected GeminiApplication getApplication() {
        return this.application;
    }

    protected String getPropsPrefix() {
        return this.propsPrefix;
    }

    protected LoginTokenManager getLoginTokenManager() {
        return this.loginTokenManager;
    }

    protected class LoginAttempt {
        private int count = 0;
        private long resetTime = 0L;

        public void setFailState() {
            this.count = 0;
            this.resetTime = System.currentTimeMillis() + (long)BasicLoginHandler.this.failedResetSeconds * 1000L;
        }

        public boolean isGood() {
            return this.resetTime < System.currentTimeMillis();
        }

        public void attempt() {
            ++this.count;
            if (this.count >= BasicLoginHandler.this.failedAttemptLimit) {
                this.setFailState();
            }
        }
    }
}

