/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis;

import com.techempower.gemini.pyxis.BasicSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.PyxisUserGroup;
import com.techempower.helper.StringHelper;
import com.techempower.util.Initializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;

public class BasicUser
implements PyxisUser,
Initializable {
    public static final int MAX_USERNAME_LENGTH = 100;
    public static final int MIN_USERNAME_LENGTH = 4;
    public static final int MAX_PASSWORD_LENGTH = 30;
    public static final int MIN_PASSWORD_LENGTH = 4;
    public static final int MAX_NAME_LENGTH = 50;
    public static final Comparator<BasicUser> SORT_LASTNAME_FIRSTNAME = new SortLastnameFirstname();
    private int userID = 0;
    private String userUsername = "";
    private String userPassword = "";
    private String userFullname = "";
    private String userFirstname = "";
    private String userLastname = "";
    private boolean enabled = true;
    private int[] userGroups = new int[0];
    private Date userLastLogin = null;
    private Date userLastPasswordChange = null;
    private transient boolean userGroupsSet = false;
    private transient boolean memberAdministrators = false;
    private transient boolean memberUsers = false;
    private transient boolean memberGuests = false;
    private transient boolean initialized = false;
    private BasicSecurity<? extends PyxisUser, ? extends PyxisUserGroup> security;

    public BasicUser(BasicSecurity<? extends PyxisUser, ? extends PyxisUserGroup> security) {
        this.security = security;
    }

    public BasicSecurity<? extends PyxisUser, ? extends PyxisUserGroup> getSecurity() {
        return this.security;
    }

    @Override
    public void setUserID(int userID) {
        this.userID = userID;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setUserUsername(String username) {
        this.userUsername = username == null ? null : StringHelper.trim(StringHelper.truncate(username, 100)).toLowerCase();
    }

    @Override
    public void setUserPassword(String password) {
        this.userPassword = password;
    }

    public void setUserFirstname(String firstname) {
        this.userFirstname = StringHelper.truncate(firstname, 50);
        this.generateFullname();
    }

    public void setUserLastname(String lastname) {
        this.userLastname = StringHelper.truncate(lastname, 50);
        this.generateFullname();
    }

    @Override
    public void setUserLastLogin(Date lastLogin) {
        this.userLastLogin = lastLogin != null ? new Date(lastLogin.getTime()) : null;
    }

    @Override
    public Date getUserLastLogin() {
        if (this.userLastLogin != null) {
            return new Date(this.userLastLogin.getTime());
        }
        return null;
    }

    @Override
    public void setUserLastPasswordChange(Date lastPasswordChange) {
        this.userLastPasswordChange = lastPasswordChange != null ? new Date(lastPasswordChange.getTime()) : null;
    }

    @Override
    public Date getUserLastPasswordChange() {
        if (this.userLastPasswordChange != null) {
            return new Date(this.userLastPasswordChange.getTime());
        }
        return null;
    }

    public int[] getUserGroups() {
        this.gatherUserGroups(false);
        int[] toReturn = new int[this.userGroups.length];
        System.arraycopy(this.userGroups, 0, toReturn, 0, this.userGroups.length);
        return toReturn;
    }

    public void setUserGroups(int[] groups) {
        this.userGroups = new int[groups.length];
        System.arraycopy(groups, 0, this.userGroups, 0, groups.length);
        this.evaluateGroups();
    }

    @Deprecated
    public void setUserGroups(Vector<PyxisUserGroup> groups) {
        this.userGroups = new int[groups.size()];
        int i = 0;
        while (i < groups.size()) {
            PyxisUserGroup group = groups.elementAt(i);
            this.userGroups[i] = group.getGroupID();
            ++i;
        }
        this.evaluateGroups();
    }

    public void setUserGroups(Collection<PyxisUserGroup> groups) {
        this.userGroups = new int[groups.size()];
        int i = 0;
        for (PyxisUserGroup group : groups) {
            this.userGroups[i++] = group.getId();
        }
        this.evaluateGroups();
    }

    protected void gatherUserGroups(boolean regather) {
        if (regather || !this.userGroupsSet) {
            int[] groups = this.security.getGroupsForUser(this.getUserID());
            this.setUserGroups(groups);
        }
    }

    protected boolean isUserGroupsSet() {
        return this.userGroupsSet;
    }

    @Override
    public int getUserID() {
        return this.userID;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getUserUsername() {
        return this.userUsername;
    }

    @Override
    public final String getUserPassword() {
        return this.userPassword;
    }

    public String getUserFirstname() {
        return this.userFirstname;
    }

    public String getUserLastname() {
        return this.userLastname;
    }

    public String getUserFullname() {
        return this.userFullname;
    }

    @Override
    public final boolean isAdministrator() {
        this.gatherUserGroups(false);
        return this.memberAdministrators;
    }

    @Override
    public final boolean isUser() {
        this.gatherUserGroups(false);
        return this.memberUsers;
    }

    @Override
    public final boolean isGuest() {
        this.gatherUserGroups(false);
        return this.memberGuests;
    }

    @Override
    public final boolean isMember(PyxisUserGroup group) {
        this.gatherUserGroups(false);
        if (group != null) {
            return this.isMember(group.getGroupID());
        }
        return false;
    }

    @Override
    public final boolean isMember(int groupID) {
        this.gatherUserGroups(false);
        int i = 0;
        while (i < this.userGroups.length) {
            if (this.userGroups[i] == groupID) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Deprecated
    public void initializationComplete() {
        this.initialize();
    }

    public String toString() {
        return "BasicUser [id: " + this.getUserID() + "; un: " + this.getUserUsername() + "]";
    }

    protected void evaluateGroups() {
        this.memberAdministrators = false;
        this.memberUsers = false;
        this.memberGuests = false;
        int i = 0;
        while (i < this.userGroups.length) {
            if (this.userGroups[i] == 1000) {
                this.memberAdministrators = true;
            } else if (this.userGroups[i] == 1) {
                this.memberUsers = true;
            } else if (this.userGroups[i] == 0) {
                this.memberGuests = true;
            }
            ++i;
        }
        this.userGroupsSet = true;
    }

    protected void generateFullname() {
        this.userFullname = String.valueOf(this.userFirstname) + " " + this.userLastname;
    }

    @Override
    public int getId() {
        return this.getUserID();
    }

    @Override
    public void setId(int id) {
        this.setUserID(id);
    }

    @Override
    public void initialize() {
        this.generateFullname();
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    static class SortLastnameFirstname
    implements Comparator<BasicUser> {
        SortLastnameFirstname() {
        }

        @Override
        public int compare(BasicUser u1, BasicUser u2) {
            int ln = StringHelper.compareToNullSafe(u1.getUserLastname(), u2.getUserLastname());
            if (ln < 0) {
                return -1;
            }
            if (ln > 0) {
                return 1;
            }
            int fn = StringHelper.compareToNullSafe(u1.getUserFirstname(), u2.getUserFirstname());
            if (fn < 0) {
                return -1;
            }
            if (fn > 0) {
                return 1;
            }
            return 0;
        }
    }
}

