/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis;

import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Handler;
import com.techempower.gemini.LegacyContext;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.gemini.email.outbound.EmailTemplater;
import com.techempower.gemini.form.FormHidden;
import com.techempower.gemini.form.FormSubmitButton;
import com.techempower.gemini.form.FormTextField;
import com.techempower.gemini.form.PostOnlyForm;
import com.techempower.gemini.pyxis.BasicWebUser;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.HashMap;

public class EmailVerificationHandler<D extends BasicDispatcher, C extends LegacyContext>
implements Handler<D, C>,
Configurable {
    public static final String COMPONENT_CODE = "hEvf";
    public static final String CMD_REQUEST_VERIFICATION = "ve-request";
    public static final String CMD_VERIFY = "verify-email";
    public static final String JSP_REQUEST_VERIFICATION = "email-verification-request.jsp";
    public static final String JSP_REQUEST_SENT = "email-verification-sent.jsp";
    public static final String JSP_VERIFY = "email-verify.jsp";
    public static final String JSP_VERIFY_SUCCESS = "email-verify-success.jsp";
    public static final String EMAIL_TEMPLATE_NAME = "E-EmailVerification";
    private final GeminiApplication application;
    private final ComponentLog log;
    private final PyxisSecurity security;
    private String fromAddress = "";
    private boolean verifyWithoutLogin = false;

    public EmailVerificationHandler(GeminiApplication application) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.security = application.getSecurity();
        EmailTemplater templater = application.getEmailTemplater();
        templater.addTemplateToLoad(this.getEmailTemplateName());
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.fromAddress = props.getProperty("EmailVerification.FromAddress", this.fromAddress);
        this.verifyWithoutLogin = props.getYesNoProperty("EmailVerification.VerifyWithoutLogin", false);
    }

    @Override
    public String getDescription() {
        return "Email Verification Handler";
    }

    @Override
    public int getPriority() {
        return -1000;
    }

    @Override
    public boolean acceptRequest(D dispatcher, C context, String command) {
        return command.equals(CMD_REQUEST_VERIFICATION) || command.equals(CMD_VERIFY);
    }

    @Override
    public boolean handleRequest(D dispatcher, C context, String command) {
        if (command.equals(CMD_REQUEST_VERIFICATION)) {
            return this.handleRequestForVerification((LegacyContext)context);
        }
        if (command.equals(CMD_VERIFY)) {
            return this.handleVerify((LegacyContext)context);
        }
        return false;
    }

    public boolean handleRequestForVerification(LegacyContext context) {
        BasicWebUser user = (BasicWebUser)this.security.getUser(context);
        if (user != null) {
            if (context.query().getInt("confirm") == 1) {
                user.generateNewEmailVerificationTicket();
                this.saveUser(user);
                this.sendVerificationEmail(context, user);
                return this.handleVerificationConfirmed(context, user);
            }
            String confirmURL = context.getCmdURL("ve-request&confirm=1");
            return this.handleVerificationRequest(context, user, confirmURL);
        }
        return false;
    }

    public void sendVerificationEmail(Context context, BasicWebUser user) {
        String authorAddress;
        EmailTemplater templater = this.application.getEmailTemplater();
        HashMap<String, Object> macros = new HashMap<String, Object>();
        macros.put("$UN", user.getUserUsername());
        macros.put("$FN", user.getUserFirstname());
        macros.put("$LN", user.getUserLastname());
        macros.put("$EM", user.getUserEmail());
        macros.put("$VT", user.getEmailVerificationTicket());
        macros.put("$URL", this.getVerificationURL(context, user));
        if (StringHelper.isEmpty(this.fromAddress)) {
            authorAddress = this.application.getAdministratorEmail();
            this.log.log("Using administrator e-mail address for sending verification email.", 0);
        } else {
            authorAddress = this.fromAddress;
        }
        EmailPackage email = templater.process(this.getEmailTemplateName(), macros, authorAddress, user.getUserEmail());
        if (email != null) {
            this.application.getEmailServicer().sendMail(email);
        } else {
            this.log.log("Email could not be fetched from EmailTemplater.");
        }
    }

    public String getVerificationURL(Context context, BasicWebUser user) {
        String url = context.getInfrastructure().getStandardCmdUrl("verify-email&vt=" + user.getEmailVerificationTicket());
        if (this.verifyWithoutLogin) {
            url = String.valueOf(url) + "&i=" + user.getId();
        }
        return url;
    }

    public void saveUser(BasicWebUser user) {
        this.application.getStore().put(user);
    }

    public boolean handleVerificationRequest(LegacyContext context, BasicWebUser user, String confirmURL) {
        context.delivery().put("ConfirmURL", confirmURL);
        return context.render(JSP_REQUEST_VERIFICATION);
    }

    public boolean handleVerificationConfirmed(LegacyContext context, BasicWebUser user) {
        return context.render(JSP_REQUEST_SENT);
    }

    public boolean handleVerify(LegacyContext context) {
        BasicWebUser user = (BasicWebUser)this.security.getUser(context);
        if (user == null && this.verifyWithoutLogin) {
            int id = context.query().getInt("i");
            user = (BasicWebUser)this.security.getUser(id);
        }
        if (user != null) {
            String verificationTicket = context.query().get("vt");
            if (verificationTicket != null) {
                if (user.verify(verificationTicket)) {
                    this.saveUser(user);
                    return this.handleVerificationSuccessful(context, user);
                }
                context.delivery().put("Message", "Incorrect verification ticket provided.");
            }
            return this.handleVerificationForm(context, user);
        }
        return false;
    }

    public boolean handleVerificationForm(LegacyContext context, BasicWebUser user) {
        PostOnlyForm form = new PostOnlyForm(this.application, "VerifyForm", context.getUrl(), "post");
        form.add(new FormTextField("Verification ticket", "vt", "", true, user.getEmailVerificationTicketLength(), user.getEmailVerificationTicketLength()));
        form.add(new FormHidden("i", user.getId(), true));
        form.add(new FormSubmitButton("submit", "Submit"));
        context.delivery().putObject("form", form);
        context.delivery().putObject("VerifyUser", user);
        return context.render(JSP_VERIFY);
    }

    public boolean handleVerificationSuccessful(LegacyContext context, BasicWebUser user) {
        context.delivery().putObject("VerifyUser", user);
        return context.render(JSP_VERIFY_SUCCESS);
    }

    public String getEmailTemplateName() {
        return EMAIL_TEMPLATE_NAME;
    }
}

