/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis;

import com.techempower.gemini.GeminiApplication;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;

public class PyxisSettings
implements Configurable {
    public static final int DEFAULT_EXPIRATION_DAYS = 0;
    public static final int DEFAULT_EARLY_WARNING_DAYS = 0;
    private final String propertiesPrefix;
    private boolean authenticateViaEmail = false;
    private boolean updateLastLogin = true;
    private boolean invalidateSessionAtLogout = true;
    private int expirationDays = 0;
    private int earlyWarningDays = 0;

    public PyxisSettings(GeminiApplication application) {
        this(application, "Pyxis.");
    }

    public PyxisSettings(GeminiApplication application, String prefix) {
        this.propertiesPrefix = prefix;
    }

    public boolean isEmailAuthenticationEnabled() {
        return this.authenticateViaEmail;
    }

    public boolean isLastLoginUpdate() {
        return this.updateLastLogin;
    }

    public boolean isInvalidateSessionAtLogout() {
        return this.invalidateSessionAtLogout;
    }

    public int getPasswordExpirationDays() {
        return this.expirationDays;
    }

    public int getEarlyWarningDays() {
        return this.earlyWarningDays;
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = props.focus(this.propertiesPrefix);
        this.authenticateViaEmail = focus.getYesNoProperty("AuthenticateByEmail", false);
        this.updateLastLogin = focus.getYesNoProperty("UpdateLastLogin", true);
        this.invalidateSessionAtLogout = focus.getYesNoProperty("InvalidateSessionAtLogout", true);
        this.expirationDays = focus.getIntegerProperty("PasswordExpirationDays", 0, 0, Integer.MAX_VALUE);
        this.earlyWarningDays = focus.getIntegerProperty("PasswordEarlyWarningDays", 0, 0, this.expirationDays);
    }
}

