/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.handler;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.form.BasicForm;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormCheckBox;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormHidden;
import com.techempower.gemini.form.FormPasswordField;
import com.techempower.gemini.form.FormSubmitButton;
import com.techempower.gemini.form.FormTextField;
import com.techempower.gemini.form.FormValidation;
import com.techempower.gemini.path.MethodPathHandler;
import com.techempower.gemini.path.annotation.PathDefault;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.handler.PyxisHandlerHelper;
import com.techempower.helper.StringHelper;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.HashMap;

public class LoginHandler<C extends Context>
extends MethodPathHandler<C>
implements Configurable {
    public static final String COMPONENT_CODE = "hLog";
    public static final String DEFAULT_PROPS_PREFIX = "LoginHandler.";
    public static final String SO_PRIOR_URL = "PriorURL";
    public static final String SO_TEMP_PRIOR_REQUEST = "TemporaryPriorRequest";
    public static final String DEFAULT_LOGIN_TEMPLATE = "auth/login";
    public static final String DEFAULT_SURPLUS_TEMPLATE = "auth/login-surplus";
    public static final String DEFAULT_INVALID_MESSAGE = "Invalid login. Please try again.";
    public static final String DEFAULT_SURPLUS_LOGIN_MESSAGE = "You are already logged in.";
    private final String propsPrefix;
    private final PyxisSecurity security;
    private String loginTemplate = "auth/login";
    private String invalidMessage = "Invalid login. Please try again.";
    private String surplusLoginTemplate = "auth/login-surplus";
    private String surplusLoginMessage = "You are already logged in.";

    public LoginHandler(GeminiApplication application, String propsPrefix) {
        super(application);
        this.propsPrefix = propsPrefix != null ? propsPrefix : DEFAULT_PROPS_PREFIX;
        this.app().getConfigurator().addConfigurable(this);
        this.security = this.app().getSecurity();
    }

    public LoginHandler(GeminiApplication application) {
        this(application, null);
    }

    @PathDefault
    public boolean login(Context context) {
        if (this.security.isLoggedIn(context)) {
            return this.handleSurplusLogin(context);
        }
        Form form = this.buildForm(context);
        context.delivery().putObject("form", form);
        if (form.hasBeenSubmitted(context)) {
            FormValidation formValidation = form.validate(context);
            Object usernameField = form.getElement("lhuser");
            Object passwordField = form.getElement("lhpass");
            FormCheckBox rememberField = (FormCheckBox)form.getElement("lhremember");
            String username = ((FormElement)usernameField).getStringValue().toLowerCase();
            if (formValidation.isGood() && this.performCustomValidation(context, form)) {
                String password = form.values().get("lhpass");
                boolean saveCookie = rememberField.isChecked();
                boolean success = this.security.isLoginAttemptPermitted(context);
                if (success) {
                    success = this.security.login(context, username, password, saveCookie);
                } else {
                    this.l("Too many attempts from " + context.getClientID() + "; blocked temporarily.");
                }
                if (success) {
                    return this.handlePostLogin(context);
                }
                ((FormElement)passwordField).setValue("");
                return this.handleInvalidLogin(context);
            }
            context.delivery().putObject("validation", formValidation);
        }
        return this.mustache(this.loginTemplate);
    }

    protected Form buildForm(Context context) {
        BasicForm form = new BasicForm(this.app(), "LoginForm", "", "post");
        FormElement lhuser = new FormTextField("lhuser", true, 100, 100).setDisplayName("User name");
        FormElement lhpass = new FormPasswordField("lhpass", "", true, 30, 30).setDisplayName("Password");
        FormElement lhremember = new FormCheckBox("lhremember", "", false, false).setDisplayName("Remember me");
        FormHidden lhredirect = new FormHidden("r", "").setValue(context);
        FormSubmitButton submit = new FormSubmitButton("lhlogin", "Login", true);
        form.add(lhuser).add(lhpass).add(lhremember).add(lhredirect).add(submit);
        return form;
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = PyxisHandlerHelper.getFocus(props, this.propsPrefix);
        this.loginTemplate = focus.getProperty("LoginTemplate", DEFAULT_LOGIN_TEMPLATE);
        this.surplusLoginTemplate = focus.getProperty("SurplusLoginTemplate", DEFAULT_SURPLUS_TEMPLATE);
        this.surplusLoginMessage = focus.getProperty("SurplusLoginMessage", DEFAULT_SURPLUS_LOGIN_MESSAGE);
        this.invalidMessage = focus.getProperty("InvalidMessage", DEFAULT_INVALID_MESSAGE);
    }

    protected boolean handlePostLogin(Context context) {
        String redirectUrl = context.query().get("r");
        if (StringHelper.isEmpty(redirectUrl)) {
            redirectUrl = this.security.getPostLoginUrl();
        }
        if (this.security.isExitHttpsPostLogin()) {
            redirectUrl = String.valueOf(context.getUrl()) + redirectUrl;
        }
        PyxisUser user = this.security.getUser(context);
        this.l("Login [" + user.getUserUsername() + "]; redirecting: " + redirectUrl);
        if (GeminiHelper.isJsonRequest(context)) {
            return this.postLoginJson(context, redirectUrl);
        }
        return this.postLoginTraditional(context, redirectUrl);
    }

    protected boolean postLoginJson(Context context, String redirectUrl) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("status", "ok");
        map.put("redirect", redirectUrl);
        return GeminiHelper.sendJson(context, map);
    }

    protected boolean postLoginTraditional(Context context, String redirectUrl) {
        return context.redirect(redirectUrl);
    }

    protected boolean handleInvalidLogin(Context context) {
        context.delivery().put("message", this.invalidMessage);
        return this.template(this.loginTemplate).render();
    }

    protected boolean handleSurplusLogin(Context context) {
        context.delivery().put("message", this.surplusLoginMessage);
        return this.template(this.surplusLoginTemplate).render();
    }

    protected boolean performCustomValidation(Context context, Form loginForm) {
        return true;
    }
}

