/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.handler;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.path.MethodPathHandler;
import com.techempower.gemini.path.PathSegments;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.annotation.PathBypassAuth;
import com.techempower.gemini.pyxis.authorization.Authorizer;
import com.techempower.gemini.pyxis.authorization.Rejector;
import java.lang.reflect.Method;

public class SecurePathHandler<C extends Context, U extends PyxisUser>
extends MethodPathHandler<C> {
    private final Rejector rejector;
    private final Authorizer authorizer;
    private final PyxisSecurity security;
    private final ThreadLocal<U> user;

    public SecurePathHandler(GeminiApplication app, String componentCode, Authorizer authorizer, Rejector rejector) {
        super(app, componentCode);
        this.rejector = rejector != null ? rejector : app.getSecurity().getForceLoginRejector();
        this.authorizer = authorizer;
        this.user = new ThreadLocal();
        this.security = app.getSecurity();
    }

    public SecurePathHandler(GeminiApplication app, String componentCode) {
        this(app, componentCode, null, null);
    }

    @Override
    protected MethodPathHandler.PathSegmentMethod analyzeAnnotatedMethod(Method method) {
        MethodPathHandler.PathSegmentMethod superAnalysis = super.analyzeAnnotatedMethod(method);
        PathBypassAuth bypassAnnotation = method.getAnnotation(PathBypassAuth.class);
        boolean authorizationRequired = bypassAnnotation == null;
        return new SecurePathSegmentMethod(superAnalysis.name, superAnalysis.index, superAnalysis.contextParameter, authorizationRequired);
    }

    @Override
    public boolean prehandle(PathSegments segments, C context) {
        if (super.prehandle(segments, context)) {
            return true;
        }
        SecurePathSegmentMethod method = this.getAnnotatedMethod(segments);
        if (!method.authorizationRequired || this.security.authCheck((Context)context, this.authorizer, this.rejector)) {
            PyxisUser currentUser = this.security.getUser((Context)context);
            this.user.set(currentUser);
            return false;
        }
        this.user.remove();
        return true;
    }

    @Override
    public void posthandle(PathSegments segments, C context) {
        try {
            super.posthandle(segments, context);
        }
        finally {
            this.user.remove();
        }
    }

    @Override
    protected SecurePathSegmentMethod getAnnotatedMethod(PathSegments segments) {
        return (SecurePathSegmentMethod)super.getAnnotatedMethod(segments);
    }

    public U user() {
        return (U)((PyxisUser)this.user.get());
    }

    protected static class SecurePathSegmentMethod
    extends MethodPathHandler.PathSegmentMethod {
        final boolean authorizationRequired;

        protected SecurePathSegmentMethod(String name, int index, boolean contextParameter, boolean authorizationRequired) {
            super(name, index, contextParameter);
            this.authorizationRequired = authorizationRequired;
        }
    }
}

