/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.listener;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.notification.BasicNotification;
import com.techempower.gemini.admin.notification.Notification;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.listener.SecurityListener;
import com.techempower.gemini.pyxis.password.PasswordProposal;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;

public class AbuseListener
implements SecurityListener<Context>,
Configurable {
    public static final String COMPONENT_CODE = "Abus";
    public static final String DEFAULT_PROPS_PREFIX = "AbuseListener.";
    public static final int THRESHOLD_MINUTE = 20;
    public static final int THRESHOLD_HOUR = 200;
    public static final int THRESHOLD_DAY = 2000;
    public static final String CRLF = "\r\n";
    private final GeminiApplication application;
    private final ComponentLog log;
    private final String propsPrefix;
    private int thresholdMinute = 20;
    private int thresholdHour = 200;
    private int thresholdDay = 2000;
    private int countMinute = 0;
    private int countHour = 0;
    private int countDay = 0;
    private long nextMinute = 0L;
    private long nextHour = 0L;
    private long nextDay = 0L;
    private long lastAlert = 0L;
    private final long alertInterval = 3600000L;
    private int alertsSinceLast = 0;

    public AbuseListener(GeminiApplication application, String propsPrefix) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.propsPrefix = StringHelper.isNonEmpty(propsPrefix) ? propsPrefix : DEFAULT_PROPS_PREFIX;
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void loginFailed(Context context) {
        long current = System.currentTimeMillis();
        if (current > this.nextMinute) {
            this.nextMinute = current + 60000L;
            this.countMinute = 0;
        }
        ++this.countMinute;
        if (this.countMinute > this.thresholdMinute) {
            this.processAlert("Excessive login failures in past minute.  " + this.countMinute + " failure(s) tracked so far.");
        }
        if (current > this.nextHour) {
            this.nextHour = current + 3600000L;
            this.countHour = 0;
        }
        ++this.countHour;
        if (this.countHour > this.thresholdHour) {
            this.processAlert("Excessive login failures in past hour.  " + this.countHour + " failure(s) tracked so far.");
        }
        if (current > this.nextDay) {
            this.nextDay = current + 86400000L;
            this.countDay = 0;
        }
        ++this.countDay;
        if (this.countDay > this.thresholdDay) {
            this.processAlert("Excessive login failures in past day.  " + this.countDay + " failure(s) tracked so far.");
        }
    }

    protected synchronized void processAlert(String alert) {
        this.log.log(alert);
        long current = System.currentTimeMillis();
        if (current > this.lastAlert + 3600000L) {
            StringBuilder buff = new StringBuilder(1000);
            buff.append("Security Alert: " + alert + CRLF);
            if (this.alertsSinceLast > 0) {
                buff.append("----\r\n");
                buff.append(String.valueOf(this.alertsSinceLast) + " alert" + StringHelper.pluralize(this.alertsSinceLast) + " skipped since last report" + CRLF);
                this.alertsSinceLast = 0;
            }
            BasicNotification notification = new BasicNotification("abuse", alert, buff.toString(), Notification.Severity.LOW);
            this.application.getNotifier().addNotification(notification);
            this.lastAlert = current;
        } else {
            ++this.alertsSinceLast;
        }
    }

    @Override
    public void loginSuccessful(Context context, PyxisUser user) {
    }

    @Override
    public void logoutSuccessful(Context context, PyxisUser user) {
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.thresholdMinute = props.getIntegerProperty(String.valueOf(this.propsPrefix) + "ThresholdMinute", this.thresholdMinute);
        this.thresholdHour = props.getIntegerProperty(String.valueOf(this.propsPrefix) + "ThresholdHour", this.thresholdHour);
        this.thresholdDay = props.getIntegerProperty(String.valueOf(this.propsPrefix) + "ThresholdDay", this.thresholdDay);
    }

    @Override
    public void passwordChanged(PasswordProposal proposal) {
    }
}

