/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.password;

import com.techempower.gemini.pyxis.password.PasswordProposal;
import com.techempower.gemini.pyxis.password.PasswordRequirement;
import com.techempower.helper.StringHelper;
import com.techempower.util.StringList;

public class PasswordComplexity
implements PasswordRequirement {
    public static final int DEFAULT_MIN_UPPERCASE = 1;
    public static final int DEFAULT_MIN_LOWERCASE = 1;
    public static final int DEFAULT_NUMERIC = 1;
    public static final int DEFAULT_OTHER = 1;
    private final int minUppercase;
    private final int minLowercase;
    private final int minNumeric;
    private final int minOther;
    private final String synopsis;

    public PasswordComplexity(int minUppercase, int minLowercase, int minNumeric, int minOther) {
        this.minLowercase = minLowercase;
        this.minNumeric = minNumeric;
        this.minUppercase = minUppercase;
        this.minOther = minOther;
        StringList rules = StringList.getPlainEnglishList();
        if (minUppercase > 0) {
            rules.add(String.valueOf(minUppercase) + " uppercase letter" + StringHelper.pluralize(minUppercase));
        }
        if (minLowercase > 0) {
            rules.add(String.valueOf(minLowercase) + " lowercase letter" + StringHelper.pluralize(minLowercase));
        }
        if (minNumeric > 0) {
            rules.add(String.valueOf(minNumeric) + " number" + StringHelper.pluralize(minNumeric));
        }
        if (minOther > 0) {
            rules.add(String.valueOf(minOther) + " other character" + StringHelper.pluralize(minOther));
        }
        this.synopsis = rules.toString();
    }

    public PasswordComplexity() {
        this(1, 1, 1, 1);
    }

    @Override
    public String validate(PasswordProposal proposal) {
        int uc = 0;
        int lc = 0;
        int n = 0;
        int o = 0;
        int i = 0;
        while (i < proposal.password.length()) {
            char c = proposal.password.charAt(i);
            if (c >= '0' && c <= '9') {
                ++n;
            } else if (c >= 'a' && c <= 'z') {
                ++lc;
            } else if (c >= 'A' && c <= 'Z') {
                ++uc;
            } else {
                ++o;
            }
            ++i;
        }
        if (this.minUppercase > 0 && uc < this.minUppercase || this.minLowercase > 0 && lc < this.minLowercase || this.minNumeric > 0 && n < this.minNumeric || this.minOther > 0 && o < this.minOther) {
            return "Passwords must contain at least " + this.synopsis + ".";
        }
        return null;
    }
}

