/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.password;

import com.techempower.gemini.pyxis.password.PasswordProposal;
import com.techempower.gemini.pyxis.password.PasswordRequirement;
import com.techempower.helper.StringHelper;

public class PasswordDisallowedString
implements PasswordRequirement {
    private final String disallowed;
    private final boolean matchCase;

    public PasswordDisallowedString(String disallowedString, boolean onlyDisallowMatchingCase) {
        this.disallowed = disallowedString;
        this.matchCase = onlyDisallowMatchingCase;
    }

    @Override
    public String validate(PasswordProposal proposal) {
        return this.validate(proposal, this.disallowed);
    }

    protected String validate(PasswordProposal proposal, String disallowedString) {
        if (StringHelper.isNonEmpty(disallowedString)) {
            if (this.matchCase && StringHelper.containsIgnoreCase(proposal.password, disallowedString)) {
                return "Password may not contain \"" + disallowedString + "\".";
            }
            if (!this.matchCase && proposal.password.contains(disallowedString)) {
                return "Password may not contain a variation of \"" + disallowedString + "\".";
            }
        }
        return null;
    }
}

