/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.util;

import com.techempower.gemini.Context;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class Paging {
    public static final int DEFAULT_ITEMS_PER_PAGE = 10;
    public static final int DEFAULT_PAGES_BEFORE_CURRENT = 2;
    public static final int DEFAULT_PAGES_AFTER_CURRENT = 2;
    public static final int DEFAULT_PAGES_AT_BEGINNING = 2;
    public static final int DEFAULT_PAGES_AT_END = 2;
    public static final String DEFAULT_PREVIOUS_PAGE_HTML = "Previous";
    public static final String DEFAULT_NEXT_PAGE_HTML = "Next";
    public static final String DEFAULT_BLOCK_ELLIPSIS_HTML = "...";
    public static final String DEFAULT_INLINE_ELLIPSIS_HTML = " ... ";
    public static final String[] TOKENS = new String[]{"$N", "$L", "$U"};
    public static final String DEFAULT_PAGE_FORMAT = "<a title=\"Go to page $N\" href=\"$U\">$L</a>";
    public static final String DEFAULT_CURRENT_PAGE_FORMAT = "<b>$L</b>";
    private URLGenerator urlGenerator;
    private String baseURL;
    private String pageParameterName;
    private String pageSizeParameterName;
    private int currentPage;
    private int itemCount;
    private int itemsPerPage;
    private int itemsPerPageMinimum = 1;
    private int itemsPerPageMaximum = Integer.MAX_VALUE;
    private int pagesBeforeCurrent;
    private int pagesAfterCurrent;
    private int pagesAtBeginning;
    private int pagesAtEnd;
    private int pageCount;
    private int firstDisplayedPage;
    private int lastDisplayedPage;
    private int firstDisplayedResult;
    private int lastDisplayedResult;
    private boolean previousPageDisplayed;
    private boolean nextPageDisplayed;
    private int lastPageAtBeginning;
    private int firstPageAtEnd;
    private boolean firstEllipsisDisplayed;
    private boolean lastEllipsisDisplayed;

    public Paging(String baseURL, String pageParameterName, int itemCount) {
        this(baseURL, pageParameterName, itemCount, 1);
    }

    public Paging(String baseURL, String pageParameterName, int itemCount, int currentPage) {
        this(baseURL, pageParameterName, itemCount, currentPage, 10);
    }

    public Paging(String baseURL, String pageParameterName, int itemCount, int currentPage, int itemsPerPage) {
        this(baseURL, pageParameterName, itemCount, currentPage, itemsPerPage, 2, 2);
    }

    public Paging(String baseURL, String pageParameterName, int itemCount, int currentPage, int itemsPerPage, int pagesBeforeCurrent, int pagesAfterCurrent) {
        this(baseURL, pageParameterName, itemCount, currentPage, itemsPerPage, pagesBeforeCurrent, pagesAfterCurrent, 2, 2);
    }

    public Paging(String baseURL, String pageParameterName, int itemCount, int currentPage, int itemsPerPage, int pagesBeforeCurrent, int pagesAfterCurrent, int pagesAtBeginning, int pagesAtEnd) {
        this.baseURL = baseURL;
        this.pageParameterName = pageParameterName;
        this.itemCount = itemCount;
        this.currentPage = currentPage;
        this.setItemsPerPage(itemsPerPage);
        this.pagesBeforeCurrent = pagesBeforeCurrent;
        this.pagesAfterCurrent = pagesAfterCurrent;
        this.pagesAtBeginning = pagesAtBeginning;
        this.pagesAtEnd = pagesAtEnd;
        this.recalculate();
    }

    public Paging(URLGenerator urlGenerator, int itemCount) {
        this(urlGenerator, itemCount, 1);
    }

    public Paging(URLGenerator urlGenerator, int itemCount, int currentPage) {
        this(urlGenerator, itemCount, currentPage, 10);
    }

    public Paging(URLGenerator urlGenerator, int itemCount, int currentPage, int itemsPerPage) {
        this(urlGenerator, itemCount, currentPage, itemsPerPage, 2, 2);
    }

    public Paging(URLGenerator urlGenerator, int itemCount, int currentPage, int itemsPerPage, int pagesBeforeCurrent, int pagesAfterCurrent) {
        this(urlGenerator, itemCount, currentPage, itemsPerPage, pagesBeforeCurrent, pagesAfterCurrent, 2, 2);
    }

    public Paging(URLGenerator urlGenerator, int itemCount, int currentPage, int itemsPerPage, int pagesBeforeCurrent, int pagesAfterCurrent, int pagesAtBeginning, int pagesAtEnd) {
        this.urlGenerator = urlGenerator;
        this.currentPage = currentPage;
        this.itemCount = itemCount;
        this.setItemsPerPage(itemsPerPage);
        this.pagesBeforeCurrent = pagesBeforeCurrent;
        this.pagesAfterCurrent = pagesAfterCurrent;
        this.pagesAtBeginning = pagesAtBeginning;
        this.pagesAtEnd = pagesAtEnd;
        this.recalculate();
    }

    private void recalculate() {
        this.pageCount = this.itemCount / this.itemsPerPage;
        if (this.itemCount % this.itemsPerPage > 0) {
            ++this.pageCount;
        }
        this.firstDisplayedPage = this.currentPage - this.pagesBeforeCurrent;
        if (this.firstDisplayedPage < 1) {
            this.firstDisplayedPage = 1;
        }
        this.lastDisplayedPage = this.currentPage + this.pagesAfterCurrent;
        if (this.lastDisplayedPage > this.pageCount) {
            this.lastDisplayedPage = this.pageCount;
        }
        this.firstDisplayedResult = 1 + (this.currentPage - 1) * this.itemsPerPage;
        this.lastDisplayedResult = this.currentPage * this.itemsPerPage > this.itemCount ? this.itemCount : this.currentPage * this.itemsPerPage;
        this.previousPageDisplayed = this.currentPage > 1;
        this.nextPageDisplayed = this.currentPage < this.pageCount;
        this.lastPageAtBeginning = Math.min(1 + this.pagesAtBeginning, this.firstDisplayedPage) - 1;
        this.firstPageAtEnd = Math.max(this.lastDisplayedPage + 1, this.pageCount - this.pagesAtEnd + 1);
        this.firstEllipsisDisplayed = this.pagesAtBeginning > 0 && this.firstDisplayedPage > this.pagesAtBeginning + 1;
        this.lastEllipsisDisplayed = this.pagesAtEnd > 0 && this.lastDisplayedPage < this.pageCount - this.pagesAtEnd;
    }

    public void readParameters(Context context) {
        int pageNumber = context.query().getInt(this.getPageParameterName(), 1);
        int pageSize = context.query().getInt(this.getPageSizeName(), this.getItemsPerPage());
        this.setCurrentPage(pageNumber);
        this.setItemsPerPage(pageSize);
    }

    public String renderAsSpan(Context context) {
        return this.renderAsSpan(context, null);
    }

    public String renderAsSpan(Context context, String cssClassName) {
        return this.renderAsSpan(context, cssClassName, null);
    }

    public String renderAsSpan(Context context, String cssClassName, String innerPrefixHTML) {
        return this.renderAsSpan(context, cssClassName, innerPrefixHTML, null, " ");
    }

    public String renderAsSpan(Context context, String cssClassName, String innerPrefixHTML, String innerSuffixHTML, String itemSeparatorHTML) {
        return this.renderAsSpan(context, cssClassName, innerPrefixHTML, innerSuffixHTML, itemSeparatorHTML, DEFAULT_PREVIOUS_PAGE_HTML, DEFAULT_NEXT_PAGE_HTML, DEFAULT_INLINE_ELLIPSIS_HTML);
    }

    public String renderAsSpan(Context context, String cssClassName, String innerPrefixHTML, String innerSuffixHTML, String itemSeparatorHTML, String previousPageHTML, String nextPageHTML, String ellipsisHTML) {
        return this.render(context, StringHelper.isEmpty(cssClassName) ? "<span>" : "<span class=\"" + cssClassName + "\">", "</span>", null, null, innerPrefixHTML, innerSuffixHTML, itemSeparatorHTML, previousPageHTML, nextPageHTML, ellipsisHTML);
    }

    public String renderAsParagraph(Context context) {
        return this.renderAsParagraph(context, null);
    }

    public String renderAsParagraph(Context context, String cssClassName) {
        return this.renderAsParagraph(context, cssClassName, null);
    }

    public String renderAsParagraph(Context context, String cssClassName, String innerPrefixHTML) {
        return this.renderAsParagraph(context, cssClassName, innerPrefixHTML, null, " ");
    }

    public String renderAsParagraph(Context context, String cssClassName, String innerPrefixHTML, String innerSuffixHTML, String itemSeparatorHTML) {
        return this.renderAsParagraph(context, cssClassName, innerPrefixHTML, innerSuffixHTML, itemSeparatorHTML, DEFAULT_PREVIOUS_PAGE_HTML, DEFAULT_NEXT_PAGE_HTML, DEFAULT_INLINE_ELLIPSIS_HTML);
    }

    public String renderAsParagraph(Context context, String cssClassName, String innerPrefixHTML, String innerSuffixHTML, String itemSeparatorHTML, String previousPageHTML, String nextPageHTML, String ellipsisHTML) {
        return this.render(context, StringHelper.isEmpty(cssClassName) ? "<p>" : "<p class=\"" + cssClassName + "\">", "</p>", null, null, innerPrefixHTML, innerSuffixHTML, itemSeparatorHTML, previousPageHTML, nextPageHTML, ellipsisHTML);
    }

    public String renderAsList(Context context) {
        return this.renderAsList(context, null);
    }

    public String renderAsList(Context context, String cssClassName) {
        return this.renderAsList(context, cssClassName, null);
    }

    public String renderAsList(Context context, String cssClassName, String innerPrefixHTML) {
        return this.renderAsList(context, cssClassName, innerPrefixHTML, null);
    }

    public String renderAsList(Context context, String cssClassName, String innerPrefixHTML, String innerSuffixHTML) {
        return this.renderAsList(context, cssClassName, null, null, DEFAULT_PREVIOUS_PAGE_HTML, DEFAULT_NEXT_PAGE_HTML, DEFAULT_BLOCK_ELLIPSIS_HTML);
    }

    public String renderAsList(Context context, String cssClassName, String innerPrefixHTML, String innerSuffixHTML, String previousPageHTML, String nextPageHTML, String ellipsisHTML) {
        return this.render(context, StringHelper.isEmpty(cssClassName) ? "<ul>" : "<ul class=\"" + cssClassName + "\">", "</ul>", "<li>", "</li>", innerPrefixHTML, innerSuffixHTML, null, previousPageHTML, nextPageHTML, ellipsisHTML);
    }

    public String renderAsTable(Context context) {
        return this.renderAsTable(context, null);
    }

    public String renderAsTable(Context context, String cssClassName) {
        return this.renderAsTable(context, cssClassName, null);
    }

    public String renderAsTable(Context context, String cssClassName, String innerPrefixHTML) {
        return this.renderAsTable(context, cssClassName, innerPrefixHTML, null);
    }

    public String renderAsTable(Context context, String cssClassName, String innerPrefixHTML, String innerSuffixHTML) {
        return this.renderAsTable(context, cssClassName, innerPrefixHTML, innerSuffixHTML, DEFAULT_PREVIOUS_PAGE_HTML, DEFAULT_NEXT_PAGE_HTML, DEFAULT_BLOCK_ELLIPSIS_HTML);
    }

    public String renderAsTable(Context context, String cssClassName, String innerPrefixHTML, String innerSuffixHTML, String previousPageHTML, String nextPageHTML, String ellipsisHTML) {
        return this.render(context, StringHelper.isEmpty(cssClassName) ? "<table cellspacing=\"0\"><tbody><tr>" : "<table cellspacing=\"0\" class=\"" + cssClassName + "\"><tbody><tr>", "</tr></tbody></table>", "<td>", "</td>", innerPrefixHTML, innerSuffixHTML, null, previousPageHTML, nextPageHTML, ellipsisHTML);
    }

    public String render(Context context, String outerPrefixHTML, String outerSuffixHTML, String itemPrefixHTML, String itemSuffixHTML, String innerPrefixHTML, String innerSuffixHTML, String itemSeparatorHTML, String previousPageHTML, String nextPageHTML, String ellipsisHTML) {
        return this.render(context, outerPrefixHTML, outerSuffixHTML, itemPrefixHTML, itemSuffixHTML, innerPrefixHTML, innerSuffixHTML, itemSeparatorHTML, previousPageHTML, nextPageHTML, ellipsisHTML, 2, "", DEFAULT_PAGE_FORMAT, DEFAULT_CURRENT_PAGE_FORMAT);
    }

    public String render(Context context, String outerPrefixHTML, String outerSuffixHTML, String itemPrefixHTML, String itemSuffixHTML, String innerPrefixHTML, String innerSuffixHTML, String itemSeparatorHTML, String previousPageHTML, String nextPageHTML, String ellipsisHTML, int minPages, String defaultHTML, String pageFormat, String currentPageFormat) {
        if (this.getPageCount() < minPages) {
            return defaultHTML;
        }
        boolean useItemPrefix = StringHelper.isNonEmpty(itemPrefixHTML);
        boolean useItemSuffix = StringHelper.isNonEmpty(itemSuffixHTML);
        boolean useItemSeparator = StringHelper.isNonEmpty(itemSeparatorHTML);
        StringBuilder sb = new StringBuilder();
        if (StringHelper.isNonEmpty(outerPrefixHTML)) {
            sb.append(outerPrefixHTML);
        }
        if (StringHelper.isNonEmpty(innerPrefixHTML)) {
            if (useItemPrefix) {
                sb.append(itemPrefixHTML);
            }
            sb.append(innerPrefixHTML);
            if (useItemSuffix) {
                sb.append(itemSuffixHTML);
            }
        }
        if (this.isPreviousPageDisplayed() && StringHelper.isNonEmpty(previousPageHTML)) {
            if (useItemPrefix) {
                sb.append(itemPrefixHTML);
            }
            sb.append(this.renderPage(context, this.getCurrentPage() - 1, previousPageHTML, pageFormat));
            if (useItemSuffix) {
                sb.append(itemSuffixHTML);
            }
            if (useItemSeparator) {
                sb.append(itemSeparatorHTML);
            }
        }
        int i = 1;
        while (i <= this.getLastPageAtBeginning()) {
            if (useItemPrefix) {
                sb.append(itemPrefixHTML);
            }
            sb.append(this.renderPage(context, i, Integer.toString(i), pageFormat));
            if (useItemSuffix) {
                sb.append(itemSuffixHTML);
            }
            if (useItemSeparator && (i < this.getLastPageAtBeginning() || !this.isFirstEllipsisDisplayed())) {
                sb.append(itemSeparatorHTML);
            }
            ++i;
        }
        if (this.isFirstEllipsisDisplayed() && StringHelper.isNonEmpty(ellipsisHTML)) {
            if (useItemPrefix) {
                sb.append(itemPrefixHTML);
            }
            sb.append(ellipsisHTML);
            if (useItemSuffix) {
                sb.append(itemSuffixHTML);
            }
        }
        i = this.getFirstDisplayedPage();
        while (i <= this.getLastDisplayedPage()) {
            if (useItemPrefix) {
                sb.append(itemPrefixHTML);
            }
            sb.append(this.renderPage(context, i, Integer.toString(i), this.getCurrentPage() == i ? currentPageFormat : pageFormat));
            if (useItemSuffix) {
                sb.append(itemSuffixHTML);
            }
            if (useItemSeparator && (i < this.getLastDisplayedPage() || !this.isLastEllipsisDisplayed() && this.isNextPageDisplayed() && StringHelper.isNonEmpty(nextPageHTML))) {
                sb.append(itemSeparatorHTML);
            }
            ++i;
        }
        if (this.isLastEllipsisDisplayed() && StringHelper.isNonEmpty(ellipsisHTML)) {
            if (useItemPrefix) {
                sb.append(itemPrefixHTML);
            }
            sb.append(ellipsisHTML);
            if (useItemSuffix) {
                sb.append(itemSuffixHTML);
            }
        }
        i = this.getFirstPageAtEnd();
        while (i <= this.getPageCount()) {
            if (useItemSeparator && i == this.getLastDisplayedPage() + 1) {
                sb.append(itemSeparatorHTML);
            }
            if (useItemPrefix) {
                sb.append(itemPrefixHTML);
            }
            sb.append(this.renderPage(context, i, Integer.toString(i), pageFormat));
            if (useItemSuffix) {
                sb.append(itemSuffixHTML);
            }
            if (useItemSeparator && (i < this.getPageCount() || this.isNextPageDisplayed() && StringHelper.isNonEmpty(nextPageHTML))) {
                sb.append(itemSeparatorHTML);
            }
            ++i;
        }
        if (this.isNextPageDisplayed() && StringHelper.isNonEmpty(nextPageHTML)) {
            if (useItemPrefix) {
                sb.append(itemPrefixHTML);
            }
            sb.append(this.renderPage(context, this.getCurrentPage() + 1, nextPageHTML, pageFormat));
            if (useItemSuffix) {
                sb.append(itemSuffixHTML);
            }
        }
        if (StringHelper.isNonEmpty(innerSuffixHTML)) {
            if (useItemPrefix) {
                sb.append(itemPrefixHTML);
            }
            sb.append(innerSuffixHTML);
            if (useItemSuffix) {
                sb.append(itemSuffixHTML);
            }
        }
        if (StringHelper.isNonEmpty(outerSuffixHTML)) {
            sb.append(outerSuffixHTML);
        }
        return sb.toString();
    }

    public String getURL(Context context, int page) {
        if (this.getURLGenerator() == null) {
            String ourBaseURL = this.getBaseURL();
            StringBuilder sb = new StringBuilder();
            sb.append(ourBaseURL);
            if (ourBaseURL.contains("?")) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            sb.append(this.getPageParameterName());
            sb.append("=");
            sb.append(page);
            return sb.toString();
        }
        return this.getURLGenerator().getURL(context, page);
    }

    public String renderPage(Context context, int page) {
        return this.renderPage(context, page, Integer.toString(page));
    }

    public String renderPage(Context context, int page, String labelHTML) {
        return this.renderPage(context, page, labelHTML, DEFAULT_PAGE_FORMAT);
    }

    public String renderPage(Context context, int page, String labelHTML, String format) {
        return StringHelper.replaceSubstrings(format, TOKENS, new String[]{Integer.toString(page), labelHTML, NetworkHelper.escapeStringForHtml(this.getURL(context, page))});
    }

    public <E> List<E> extractCurrentPage(List<E> items) {
        ArrayList<E> toReturn = new ArrayList<E>(this.getItemsPerPage());
        if (items.size() == this.getItemCount()) {
            int startIndex = this.getFirstDisplayedResult() - 1;
            int endIndex = this.getLastDisplayedResult();
            int i = startIndex;
            while (i < endIndex) {
                toReturn.add(items.get(i));
                ++i;
            }
        }
        return toReturn;
    }

    protected URLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    protected String getBaseURL() {
        return this.baseURL;
    }

    protected String getPageParameterName() {
        return this.pageParameterName;
    }

    protected String getPageSizeName() {
        return this.pageSizeParameterName;
    }

    protected void setPageSizeName(String pageSizeParameterName) {
        this.pageSizeParameterName = pageSizeParameterName;
    }

    public void setItemsPerPageBoundaries(int minimum, int maximum) {
        this.itemsPerPageMinimum = minimum;
        this.itemsPerPageMaximum = maximum;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = NumberHelper.boundInteger(currentPage, 1, this.getPageCount());
        this.recalculate();
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
        this.recalculate();
    }

    public int getPagesBeforeCurrent() {
        return this.pagesBeforeCurrent;
    }

    public void setPagesBeforeCurrent(int pagesBeforeCurrent) {
        this.pagesBeforeCurrent = pagesBeforeCurrent;
        this.recalculate();
    }

    public int getPagesAfterCurrent() {
        return this.pagesAfterCurrent;
    }

    public void setPagesAfterCurrent(int pagesAfterCurrent) {
        this.pagesAfterCurrent = pagesAfterCurrent;
        this.recalculate();
    }

    public int getPagesAtBeginning() {
        return this.pagesAtBeginning;
    }

    public void setPagesAtBeginning(int pagesAtBeginning) {
        this.pagesAtBeginning = pagesAtBeginning;
        this.recalculate();
    }

    public int getPagesAtEnd() {
        return this.pagesAtEnd;
    }

    public void setPagesAtEnd(int pagesAtEnd) {
        this.pagesAtEnd = pagesAtEnd;
        this.recalculate();
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = NumberHelper.boundInteger(itemsPerPage, this.itemsPerPageMinimum, this.itemsPerPageMaximum);
        this.recalculate();
    }

    public int getFirstDisplayedPage() {
        return this.firstDisplayedPage;
    }

    public int getFirstDisplayedResult() {
        return this.firstDisplayedResult;
    }

    public int getLastDisplayedPage() {
        return this.lastDisplayedPage;
    }

    public int getLastDisplayedResult() {
        return this.lastDisplayedResult;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public boolean isNextPageDisplayed() {
        return this.nextPageDisplayed;
    }

    public boolean isPreviousPageDisplayed() {
        return this.previousPageDisplayed;
    }

    public int getLastPageAtBeginning() {
        return this.lastPageAtBeginning;
    }

    public int getFirstPageAtEnd() {
        return this.firstPageAtEnd;
    }

    public boolean isFirstEllipsisDisplayed() {
        return this.firstEllipsisDisplayed;
    }

    public boolean isLastEllipsisDisplayed() {
        return this.lastEllipsisDisplayed;
    }

    public static interface URLGenerator {
        public String getURL(Context var1, int var2);
    }
}

