/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.websocket;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.websocket.WebsocketContext;
import com.techempower.gemini.websocket.WebsocketProcessor;
import com.techempower.js.JavaScriptWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public abstract class BasicWebsocketProcessor
implements WebsocketProcessor {
    private final JavaScriptWriter jsw;
    private WebsocketContext context;

    public BasicWebsocketProcessor(GeminiApplication application, JavaScriptWriter jsw) {
        this.jsw = jsw != null ? jsw : application.getJavaScriptWriter();
    }

    public BasicWebsocketProcessor(GeminiApplication application) {
        this(application, null);
    }

    @Override
    public WebsocketContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(WebsocketContext context) {
        this.context = context;
    }

    @Override
    public void startup() {
        this.getContext().setTimeout(this.getTimeout());
    }

    @Override
    public void teardown() {
    }

    public long getTimeout() {
        return 120000L;
    }

    @Override
    public void readBinary(InputStream is) throws IOException {
        byte[] discardBuffer = new byte[65536];
        while (is.available() > 0) {
            is.read(discardBuffer);
        }
    }

    @Override
    public void readText(Reader reader) throws IOException {
        char[] buffer = new char[4096];
        StringBuilder result = new StringBuilder();
        int read = 0;
        do {
            if ((read = reader.read(buffer)) < 1) continue;
            result.append(buffer, 0, read);
        } while (read >= 1);
        this.readString(result.toString());
    }

    public void readString(String string) {
    }

    public void sendJson(String messageType, Object messageData) {
        HashMap<String, Object> toSend = new HashMap<String, Object>(1);
        toSend.put(messageType, messageData);
        this.sendJson(toSend);
    }

    public void sendJson(Map<String, Object> toSend) {
        this.sendText(this.jsw.write(toSend));
    }

    @Override
    public void sendText(String text) {
        if (this.getContext() != null) {
            try {
                this.getContext().sendText(text);
            }
            catch (IOException ioexc) {
                this.close();
            }
        }
    }

    public void close() {
        if (this.getContext() != null) {
            this.getContext().close();
        }
    }
}

