/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.websocket;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.websocket.WebsocketAdapter;
import com.techempower.gemini.websocket.WebsocketHandler;
import com.techempower.gemini.websocket.WebsocketProcessor;
import com.techempower.log.ComponentLog;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebsocketServlet
extends HttpServlet {
    private static final long serialVersionUID = 4902296554565036185L;
    public static final String COMPONENT_CODE = "wssv";
    public static final String PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    private final ComponentLog log;
    private final WebsocketAdapter adapter;
    private final ConcurrentHashMap<String, WebsocketHandler> listeners;

    protected WebsocketServlet(GeminiApplication application, WebsocketAdapter adapter) {
        this.adapter = adapter;
        this.log = application.getLog(COMPONENT_CODE);
        this.listeners = new ConcurrentHashMap();
    }

    public WebsocketServlet addHandler(String protocol, WebsocketHandler handler) {
        this.listeners.put(protocol, handler);
        return this;
    }

    public void init() throws ServletException {
        super.init();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String protocol = request.getHeader(PROTOCOL_HEADER);
        WebsocketHandler handler = this.listeners.get(protocol);
        if (handler != null) {
            response.addHeader(PROTOCOL_HEADER, protocol);
            WebsocketProcessor processor = handler.handleRequest(request, response);
            if (processor != null) {
                this.adapter.promoteToWebsocket(processor, request);
                return;
            }
        } else {
            this.log.log("Bad WebSocket protocol: " + protocol, 10);
        }
        this.sendForbidden(response);
    }

    private void sendForbidden(HttpServletResponse response) {
        try {
            response.sendError(403);
        }
        catch (IOException | IllegalStateException exception) {
            // empty catch block
        }
    }
}

