/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public final class CollectionHelper {
    public static <E> E getFirst(Iterable<? extends E> objects) {
        if (objects == null) {
            return null;
        }
        Iterator<E> iterator = objects.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    public static <E> E getLast(Iterable<? extends E> objects) {
        if (objects == null) {
            return null;
        }
        if (objects instanceof List) {
            List list = (List)objects;
            if (list.isEmpty()) {
                return null;
            }
            return list.get(list.size() - 1);
        }
        E last = null;
        for (E element : objects) {
            last = element;
        }
        return last;
    }

    public static <E> E getRandom(List<? extends E> list) {
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        return list.get((int)(Math.random() * (double)list.size()));
    }

    public static <E> List<E> limit(List<E> objects, int limit) {
        if (CollectionHelper.isEmpty(objects) || objects.size() < limit) {
            return objects;
        }
        return objects.subList(0, limit);
    }

    public static <E> boolean isNonEmpty(Collection<E> inputCollection) {
        if (inputCollection != null) {
            return inputCollection.size() > 0;
        }
        return false;
    }

    public static <E> boolean isEmpty(Collection<E> inputCollection) {
        if (inputCollection != null) {
            return inputCollection.size() == 0;
        }
        return true;
    }

    public static <K, V> boolean isNonEmpty(Map<K, V> inputMap) {
        if (inputMap != null) {
            return inputMap.size() > 0;
        }
        return false;
    }

    public static <K, V> boolean isEmpty(Map<K, V> inputMap) {
        if (inputMap != null) {
            return inputMap.size() == 0;
        }
        return true;
    }

    public static <E> boolean isNonEmpty(E[] inputArray) {
        if (inputArray != null) {
            return inputArray.length > 0;
        }
        return false;
    }

    public static <E> boolean isEmpty(E[] inputArray) {
        if (inputArray != null) {
            return inputArray.length == 0;
        }
        return true;
    }

    public static <E> boolean arrayContains(E[] array, E valueToFind) {
        return CollectionHelper.arrayIndexOf(array, valueToFind) >= 0;
    }

    public static <E> int arrayIndexOf(E[] array, E valueToFind) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == valueToFind) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static boolean arrayContains(int[] array, int valueToFind) {
        return CollectionHelper.arrayIndexOf(array, valueToFind) >= 0;
    }

    public static int arrayIndexOf(int[] array, int valueToFind) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == valueToFind) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static boolean arrayContains(char[] array, char valueToFind) {
        return CollectionHelper.arrayIndexOf(array, valueToFind) >= 0;
    }

    public static int arrayIndexOf(char[] array, char valueToFind) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == valueToFind) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static boolean arrayContains(String[] array, String valueToFind) {
        return CollectionHelper.arrayIndexOf(array, valueToFind) >= 0;
    }

    public static int arrayIndexOf(String[] array, String valueToFind) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == null && valueToFind == null || array[i].equals(valueToFind)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int arrayIndexOfIgnoreCase(String[] array, String valueToFind) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == null && valueToFind == null || array[i].equalsIgnoreCase(valueToFind)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static String toString(String[] items, String delim) {
        return CollectionHelper.toString(CollectionHelper.toList(items), delim);
    }

    public static String toString(Collection<String> collection, String delim) {
        return CollectionHelper.toString(collection, delim, "");
    }

    public static String toString(Collection<String> collection, String delim, String prefix) {
        if (CollectionHelper.isNonEmpty(collection)) {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> itr = collection.iterator();
            while (itr.hasNext()) {
                if (buffer.length() > 0) {
                    buffer.append(delim);
                }
                if (StringHelper.isNonEmpty(prefix)) {
                    buffer.append(prefix);
                }
                buffer.append(itr.next());
            }
            return buffer.toString();
        }
        return "";
    }

    @SafeVarargs
    public static final <O> Map<O, O> toMapFromInterleaved(O ... sourceArray) {
        return CollectionHelper.toMapFromInterleavedImplementation(false, sourceArray);
    }

    @SafeVarargs
    public static final <O> Map<O, O> toOrderedMapFromInterleaved(O ... sourceArray) {
        return CollectionHelper.toMapFromInterleavedImplementation(true, sourceArray);
    }

    @SafeVarargs
    private static final <O> Map<O, O> toMapFromInterleavedImplementation(boolean preserveOrder, O ... sourceArray) {
        if (sourceArray == null) {
            return null;
        }
        if (sourceArray.length % 2 == 1) {
            throw new IllegalArgumentException("sourceArray must contain an even number of values.");
        }
        HashMap toReturn = preserveOrder ? new LinkedHashMap(sourceArray.length % 2) : new HashMap(sourceArray.length % 2);
        int i = 0;
        while (i < sourceArray.length) {
            toReturn.put(sourceArray[i], sourceArray[i + 1]);
            i += 2;
        }
        return toReturn;
    }

    public static <E> Vector<E> toVector(E[] objArray) {
        Vector<E> toReturn = new Vector<E>(objArray != null ? objArray.length : 0);
        int i = 0;
        while (objArray != null && i < objArray.length) {
            toReturn.add(objArray[i]);
            ++i;
        }
        return toReturn;
    }

    @SafeVarargs
    public static final <E> List<E> toList(E ... objects) {
        ArrayList list = new ArrayList(objects.length);
        Collections.addAll(list, objects);
        return list;
    }

    public static <E> List<E> toList(Iterable<? extends E> objects) {
        if (objects instanceof Collection) {
            return new ArrayList((Collection)objects);
        }
        return CollectionHelper.toList(objects.iterator());
    }

    public static <E> List<E> toList(Iterator<? extends E> objects) {
        ArrayList<E> list = new ArrayList<E>();
        while (objects.hasNext()) {
            list.add(objects.next());
        }
        return list;
    }

    @SafeVarargs
    public static final <E> Set<E> toSet(E ... objects) {
        HashSet set = new HashSet(objects.length);
        Collections.addAll(set, objects);
        return set;
    }

    public static <E> Set<E> toSet(Iterable<? extends E> objects) {
        if (objects instanceof Collection) {
            return new HashSet((Collection)objects);
        }
        return CollectionHelper.toSet(objects.iterator());
    }

    public static <E> Set<E> toSet(Iterator<? extends E> objects) {
        HashSet<E> set = new HashSet<E>();
        while (objects.hasNext()) {
            set.add(objects.next());
        }
        return set;
    }

    public static List<Integer> toList(int[] array) {
        if (array == null) {
            return new ArrayList<Integer>(0);
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static int[] toIntArray(String[] strArray) {
        int[] toReturn = new int[strArray.length];
        int i = 0;
        while (i < toReturn.length) {
            toReturn[i] = NumberHelper.parseInt(strArray[i]);
            ++i;
        }
        return toReturn;
    }

    public static int[] toIntArray(String delimitedString, String delimiter) {
        if (delimitedString == null || delimiter == null) {
            return new int[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(delimitedString, delimiter);
        int[] toReturn = new int[tokenizer.countTokens()];
        int position = 0;
        while (tokenizer.hasMoreTokens()) {
            toReturn[position++] = NumberHelper.parseInt(tokenizer.nextToken());
        }
        return toReturn;
    }

    public static int[] toIntArray(Collection<Integer> collectionOfIntegers) {
        int[] toReturn = new int[collectionOfIntegers.size()];
        int position = 0;
        for (Integer i : collectionOfIntegers) {
            toReturn[position++] = i;
        }
        return toReturn;
    }

    public static int[] toIntArrayFromStrings(Collection<String> collectionOfStrings) {
        int[] toReturn = new int[collectionOfStrings.size()];
        int position = 0;
        for (String s : collectionOfStrings) {
            toReturn[position++] = NumberHelper.parseInt(s);
        }
        return toReturn;
    }

    public static String[] toStringArray(Collection<String> collectionOfStrings) {
        return collectionOfStrings.toArray(new String[collectionOfStrings.size()]);
    }

    public static String[] toStringArray(int[] intArray) {
        String[] toReturn = new String[intArray.length];
        int i = 0;
        while (i < toReturn.length) {
            toReturn[i] = "" + intArray[i];
            ++i;
        }
        return toReturn;
    }

    public static String[] toStringArray(byte[] byteArray) {
        String[] toReturn = new String[byteArray.length];
        int i = 0;
        while (i < toReturn.length) {
            toReturn[i] = Integer.toString(byteArray[i] < 0 ? byteArray[i] + 256 : byteArray[i], 16);
            ++i;
        }
        return toReturn;
    }

    public static String toString(int[] intArray) {
        String[] strArray = CollectionHelper.toStringArray(intArray);
        return CollectionHelper.toString(strArray, ",");
    }

    public static String toString(byte[] intArray) {
        String[] strArray = CollectionHelper.toStringArray(intArray);
        return CollectionHelper.toString(strArray, ",");
    }

    public static String[] arrayMerge(boolean sort, String[] ... sourceArrays) {
        int totalSize = 0;
        if (sourceArrays != null) {
            int i = 0;
            while (i < sourceArrays.length) {
                if (sourceArrays[i] != null) {
                    totalSize += sourceArrays[i].length;
                }
                ++i;
            }
        }
        Object[] toReturn = new String[totalSize];
        int position = 0;
        if (sourceArrays != null) {
            int i = 0;
            while (i < sourceArrays.length) {
                if (sourceArrays[i] != null) {
                    System.arraycopy(sourceArrays[i], 0, toReturn, position, sourceArrays[i].length);
                    position += sourceArrays[i].length;
                }
                ++i;
            }
        }
        if (sort) {
            Arrays.sort(toReturn);
        }
        return toReturn;
    }

    public static char[] arrayMerge(boolean sort, char[] ... sourceArrays) {
        int totalSize = 0;
        if (sourceArrays != null) {
            int i = 0;
            while (i < sourceArrays.length) {
                if (sourceArrays[i] != null) {
                    totalSize += sourceArrays[i].length;
                }
                ++i;
            }
        }
        char[] toReturn = new char[totalSize];
        int position = 0;
        if (sourceArrays != null) {
            int i = 0;
            while (i < sourceArrays.length) {
                if (sourceArrays[i] != null) {
                    System.arraycopy(sourceArrays[i], 0, toReturn, position, sourceArrays[i].length);
                    position += sourceArrays[i].length;
                }
                ++i;
            }
        }
        if (sort) {
            Arrays.sort(toReturn);
        }
        return toReturn;
    }

    public static String[] getFilledArray(String value, int size) {
        String[] toReturn = new String[size];
        int i = 0;
        while (i < size) {
            toReturn[i] = value;
            ++i;
        }
        return toReturn;
    }

    public static boolean[] getFilledArray(boolean value, int size) {
        boolean[] toReturn = new boolean[size];
        Arrays.fill(toReturn, value);
        return toReturn;
    }

    public static int[] getFilledArray(int value, int size) {
        int[] toReturn = new int[size];
        Arrays.fill(toReturn, value);
        return toReturn;
    }

    public static <E> Map<String, E> getReducedMap(Map<String, E> input, String ... originalAndNewNames) {
        if (originalAndNewNames.length % 2 != 0) {
            throw new IllegalArgumentException("The original and new names array must be of even length.  Length of parameter: " + originalAndNewNames.length);
        }
        int length = originalAndNewNames.length / 2;
        HashMap<String, E> toReturn = new HashMap<String, E>(length);
        int i = 0;
        while (i < length) {
            if (originalAndNewNames[i * 2] != null) {
                E value = input.get(originalAndNewNames[i * 2]);
                toReturn.put(originalAndNewNames[i * 2 + 1], value);
            }
            ++i;
        }
        return toReturn;
    }

    public static <E> Collection<E> getIntersection(Collection<E> c1, Collection<E> c2) {
        ArrayList<E> returnCollection = new ArrayList<E>();
        if (c1 != null && c2 != null) {
            for (E o : c1) {
                try {
                    if (!c2.contains(o)) continue;
                    returnCollection.add(o);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return returnCollection;
    }

    public static <E extends Comparable<? super E>> List<E> getSorted(Iterable<? extends E> objects) {
        return CollectionHelper.sort(CollectionHelper.toList(objects));
    }

    public static <E> List<E> getSorted(Iterable<? extends E> objects, Comparator<? super E> comparator) {
        return CollectionHelper.sort(CollectionHelper.toList(objects), comparator);
    }

    public static <E extends Comparable<? super E>> List<E> sort(List<E> list) {
        Collections.sort(list);
        return list;
    }

    public static <E> List<E> sort(List<E> list, Comparator<? super E> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static <E> List<E> reverse(List<E> list) {
        Collections.reverse(list);
        return list;
    }

    public static <E> List<E> shuffle(List<E> list) {
        Collections.shuffle(list);
        return list;
    }

    private CollectionHelper() {
    }
}

