/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.helper.CollectionHelper;
import com.techempower.helper.StringHelper;

public final class CreditCardHelper {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_VISA = 1;
    public static final int TYPE_MASTERCARD = 2;
    public static final int TYPE_DISCOVER = 3;
    public static final int TYPE_AMEX = 4;
    private static final String[] TYPE_NAMES = new String[]{"Unknown", "Visa", "Mastercard", "Discover", "American Express"};
    private static final String[] TYPE_NAMES_ABBR = new String[]{"U", "V", "M", "D", "A"};
    private static final int[] TYPE_VALUES;
    private static final String[] TYPE_VALUES_STRING;
    public static final int VALIDATION_OK = 0;
    public static final int VALIDATION_UNKNOWN_CARD_TYPE = 1;
    public static final int VALIDATION_INCORRECT_LENGTH = 2;
    public static final int VALIDATION_LUHN_FAILED = 3;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        TYPE_VALUES = nArray;
        TYPE_VALUES_STRING = CollectionHelper.toStringArray(TYPE_VALUES);
    }

    public static int getType(String number, boolean checkLength) {
        return CreditCardHelper.getType(CreditCardHelper.toIntArray(number), checkLength);
    }

    public static int getType(String number) {
        return CreditCardHelper.getType(number, true);
    }

    public static int getType(byte[] number, boolean checkLength) {
        if (number.length > 4) {
            if (number[0] == 4) {
                if (!checkLength || number.length == 16 || number.length == 13) {
                    return 1;
                }
            } else if (number[0] == 5 && (number[1] == 1 || number[1] == 2 || number[1] == 3 || number[1] == 4 || number[1] == 5)) {
                if (!checkLength || number.length == 16) {
                    return 2;
                }
            } else if (number[0] == 3 && (number[1] == 4 || number[1] == 7)) {
                if (!checkLength || number.length == 15) {
                    return 4;
                }
            } else if (!(number[0] != 6 || number[1] != 0 || number[2] != 1 || number[3] != 1 || checkLength && number.length != 16)) {
                return 3;
            }
        }
        return 0;
    }

    public static int validate(String numberAsString) {
        byte[] number = CreditCardHelper.toIntArray(numberAsString);
        return CreditCardHelper.validate(number);
    }

    public static int validate(byte[] number) {
        int type = CreditCardHelper.getType(number, false);
        if (type > 0) {
            int lengthCheck = CreditCardHelper.getType(number, true);
            if (lengthCheck > 0) {
                int runningTotal = 0;
                int i = number.length - 2;
                while (i >= 0) {
                    int doubled = number[i] * 2;
                    runningTotal = doubled < 10 ? (runningTotal += doubled) : (runningTotal += 1 + doubled % 10);
                    i -= 2;
                }
                i = number.length - 1;
                while (i >= 0) {
                    runningTotal += number[i];
                    i -= 2;
                }
                if (runningTotal % 10 == 0) {
                    return 0;
                }
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public static byte[] toIntArray(String number) {
        if (StringHelper.isNonEmpty(number)) {
            String numeric = StringHelper.stripNonNumeric(number);
            byte[] digits = new byte[numeric.length()];
            int i = 0;
            while (i < digits.length) {
                int digit = numeric.charAt(i) - 48;
                digits[i] = (byte)digit;
                ++i;
            }
            return digits;
        }
        return new byte[0];
    }

    public static String obscure(String number, char obscuringCharacter, int startDigitsToShow, int endDigitsToShow) {
        StringBuilder toReturn = new StringBuilder(number.length());
        int i = 0;
        while (i < number.length()) {
            if (i >= startDigitsToShow && i < number.length() - endDigitsToShow) {
                toReturn.append(obscuringCharacter);
            } else {
                toReturn.append(number.charAt(i));
            }
            ++i;
        }
        return toReturn.toString();
    }

    public static String obscure(String number) {
        return CreditCardHelper.obscure(number, 'X', 1, 4);
    }

    public static String obscureFriendly(String number) {
        if (number.length() > 4) {
            int type = CreditCardHelper.getType(number);
            String remainder = number.substring(number.length() - 4);
            return String.valueOf(TYPE_NAMES[type]) + " ending with " + remainder;
        }
        return "Unknown";
    }

    public static String[] getTypeNames() {
        return (String[])TYPE_NAMES.clone();
    }

    public static String[] getTypeNamesAbbr() {
        return (String[])TYPE_NAMES_ABBR.clone();
    }

    public static int[] getTypeValues() {
        return (int[])TYPE_VALUES.clone();
    }

    public static String[] getTypeValuesString() {
        return (String[])TYPE_VALUES_STRING.clone();
    }

    private CreditCardHelper() {
    }
}

