/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.data.ConnectorFactory;
import com.techempower.data.DatabaseConnector;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.StringHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public final class DatabaseHelper {
    private static final String[] MYSQL_ESCAPE_FINDS = new String[]{"'", "\\"};
    private static final String[] MYSQL_ESCAPE_REPLACES = new String[]{"''", "\\\\"};

    public static String prepare(String inputString) {
        return String.valueOf('\'') + StringHelper.escapeSingleQuotes(inputString) + '\'';
    }

    public static String prepareMySql(String inputString) {
        return String.valueOf('\'') + StringHelper.replaceSubstrings(inputString, MYSQL_ESCAPE_FINDS, MYSQL_ESCAPE_REPLACES) + '\'';
    }

    public static String prepare(Date date) {
        Timestamp ts = new Timestamp(date.getTime());
        return String.valueOf('\'') + ts.toString() + '\'';
    }

    public static String prepare(Calendar cal) {
        Timestamp ts = new Timestamp(cal.getTime().getTime());
        return String.valueOf('\'') + ts.toString() + '\'';
    }

    public static String prepareDoubleQuote(String inputString) {
        return String.valueOf('\"') + StringHelper.escapeDoubleQuotes(inputString) + '\"';
    }

    public static <E> String prepareInClause(Collection<E> obs, boolean mysql) {
        StringBuilder sb = new StringBuilder();
        if (CollectionHelper.isNonEmpty(obs)) {
            for (E o : obs) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (StringHelper.isAllNumeric(String.valueOf(o))) {
                    sb.append(o);
                    continue;
                }
                if (o instanceof Date) {
                    sb.append(DatabaseHelper.prepare((Date)o));
                    continue;
                }
                if (o instanceof Calendar) {
                    sb.append(DatabaseHelper.prepare((Calendar)o));
                    continue;
                }
                if (!mysql) {
                    sb.append(DatabaseHelper.prepare((String)o));
                    continue;
                }
                sb.append(DatabaseHelper.prepareMySql((String)o));
            }
            sb.insert(0, "(");
            sb.append(")");
            return sb.toString();
        }
        return null;
    }

    public static String quoteTableOrColumn(ConnectorFactory connectorFactory, String tableOrColumn) {
        Objects.requireNonNull(connectorFactory);
        Objects.requireNonNull(tableOrColumn);
        String quote = connectorFactory.getIdentifierQuoteString();
        return String.valueOf(quote) + tableOrColumn + quote;
    }

    @Deprecated
    public static void closeQuietly(DatabaseConnector connector) {
        if (connector != null) {
            try {
                connector.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public static void closeQuietly(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public static void closeQuietly(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public static void closeQuietly(PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DatabaseHelper() {
    }
}

