/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileHelper {
    public static final String PERMISSIBLE_FILENAME_CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ {}[].,;'!@#$%^&()_-=+~`";
    private static final int BYTE_BUFFER_SIZE = 4096;

    public static String getExtension(String filename) {
        int lastPeriod = filename.lastIndexOf(46);
        int lastForwardslash = filename.lastIndexOf(47);
        int lastBackslash = filename.lastIndexOf(92);
        if (lastPeriod > lastForwardslash && lastPeriod > lastBackslash && lastPeriod < filename.length()) {
            return filename.substring(lastPeriod + 1);
        }
        return "";
    }

    public static String replaceExtension(String filename, String newExtension) {
        StringBuilder newFilename = new StringBuilder(filename.length() + newExtension.length());
        String currentExtension = FileHelper.getExtension(filename);
        newFilename.append(filename.substring(0, filename.length() - currentExtension.length()));
        newFilename.append(newExtension);
        return newFilename.toString();
    }

    public static String normalizeFilename(String filename) {
        StringBuilder toReturn = new StringBuilder(filename.length());
        int i = 0;
        while (i < filename.length()) {
            char current = filename.charAt(i);
            if (PERMISSIBLE_FILENAME_CHARACTERS.contains("" + current)) {
                toReturn.append(current);
            } else {
                toReturn.append('-');
            }
            ++i;
        }
        return toReturn.toString();
    }

    public static String concatenatePaths(String part1, String part2) {
        String p1 = part1 != null ? part1 : "";
        String p2 = part2 != null ? part2 : "";
        p1 = FileHelper.stripSlashesRight(p1);
        p2 = FileHelper.stripSlashesLeft(p2);
        return String.valueOf(p1) + File.separator + p2;
    }

    public static String stripSlashesLeft(String str) {
        if (str == null || str.length() == 0 || !str.startsWith("/") && !str.startsWith(File.separator)) {
            return str;
        }
        return FileHelper.stripSlashesLeft(str.substring(1));
    }

    public static String stripSlashesRight(String str) {
        if (str == null || str.length() == 0 || !str.endsWith("/") && !str.endsWith(File.separator)) {
            return str;
        }
        return FileHelper.stripSlashesRight(str.substring(0, str.length() - 1));
    }

    public static void copyStreamContents(InputStream inputStream, OutputStream outputStream, long length) throws IOException {
        long fileRemaining = length == 0L ? (long)inputStream.available() : length;
        byte[] buffer = new byte[4096];
        while (fileRemaining > 0L) {
            int toRead = 4096;
            if ((long)toRead > fileRemaining) {
                toRead = (int)fileRemaining;
            }
            int read = inputStream.read(buffer, 0, toRead);
            outputStream.write(buffer, 0, read);
            fileRemaining -= (long)read;
            if (length != 0L) continue;
            fileRemaining = inputStream.available();
        }
        outputStream.flush();
    }

    private FileHelper() {
    }
}

