/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.helper.StringHelper;
import com.techempower.io.image.ByteArrayOutputConsumer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.im4java.core.ConvertCmd;
import org.im4java.core.GMOperation;
import org.im4java.core.IM4JavaException;
import org.im4java.core.Operation;
import org.im4java.process.InputProvider;
import org.im4java.process.OutputConsumer;
import org.im4java.process.Pipe;

public final class ImageHelper {
    public static BufferedImage createBufferedImage(MagickParams params, ImageTransform imageTransform) {
        try {
            byte[] outBytes = ImageHelper.transformImage(params, imageTransform);
            if (outBytes == null) {
                return ImageIO.read(params.getDestFile());
            }
            return ImageIO.read(ImageIO.createImageInputStream(outBytes));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] transformImage(MagickParams params, ImageTransform imageTransform) {
        ConvertCmd cmd = null;
        ByteArrayInputStream bais = null;
        try {
            GMOperation op = new GMOperation();
            if (params.getSourceFile() != null) {
                op.addImage(new String[]{params.getSourceFile().getAbsolutePath()});
            } else if (params.getImageFileData() != null) {
                op.addImage(new String[]{"-"});
            }
            Integer w = imageTransform.getNewWidth();
            Integer h = imageTransform.getNewHeight();
            if (w != null || h != null) {
                if (!imageTransform.isPreserveAspect()) {
                    op.resize(w, h, Character.valueOf('!'));
                } else if (imageTransform.isCropToFit()) {
                    op.resize(w, h, Character.valueOf('^'));
                    int offsetY = 0;
                    int offsetX = 0;
                    Integer oldW = imageTransform.getOldWidth();
                    Integer oldH = imageTransform.getOldHeight();
                    if (oldW != null && oldH != null) {
                        int newWidth = w;
                        int newHeight = h;
                        if (w < h) {
                            if (oldH >= oldW) {
                                newWidth = (int)((double)oldW.intValue() * (double)h.intValue() / (double)oldH.intValue());
                            }
                            if (oldH <= oldW) {
                                newHeight = (int)((double)oldH.intValue() * (double)w.intValue() / (double)oldW.intValue());
                            }
                        } else if (h < w) {
                            if (oldH >= oldW) {
                                newHeight = (int)((double)oldH.intValue() * (double)w.intValue() / (double)oldW.intValue());
                            } else if (oldH <= oldW) {
                                newWidth = (int)((double)oldW.intValue() * (double)h.intValue() / (double)oldH.intValue());
                            }
                        }
                        if (newWidth > w) {
                            offsetX = (newWidth - w) / 2;
                        }
                        if (newHeight > h) {
                            offsetY = (newHeight - h) / 2;
                        }
                    }
                    op.crop(w, h, Integer.valueOf(offsetX), Integer.valueOf(offsetY));
                } else {
                    op.resize(w, h);
                }
            }
            if (imageTransform.isFlatten()) {
                op.flatten();
            }
            if (imageTransform.getQuality() != null) {
                op.quality(imageTransform.getQuality());
            }
            op.p_profile("*");
            String outPath = "-";
            if (params.getDestFile() != null) {
                outPath = params.getDestFile().getAbsolutePath();
            }
            if (StringHelper.isEmptyTrimmed(imageTransform.getNewFormat())) {
                op.addImage(new String[]{outPath});
            } else {
                op.addImage(new String[]{String.valueOf(imageTransform.getNewFormat().trim()) + ":" + outPath});
            }
            cmd = new ConvertCmd(params.usesGraphicsMagick());
            if (params.getSourceFile() == null) {
                bais = new ByteArrayInputStream(params.getImageFileData());
                Pipe pipeIn = new Pipe((InputStream)bais, null);
                cmd.setInputProvider((InputProvider)pipeIn);
            }
            ByteArrayOutputConsumer out = null;
            if (params.getDestFile() == null) {
                out = new ByteArrayOutputConsumer();
                cmd.setOutputConsumer((OutputConsumer)out);
            }
            cmd.run((Operation)op, new Object[0]);
            if (out == null) {
                return null;
            }
            byte[] byArray = out.getRawBytes();
            return byArray;
        }
        catch (IOException | InterruptedException | IM4JavaException throwable) {
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static void main(String[] args) {
    }

    public static void debug(String text) {
    }

    private ImageHelper() {
    }

    public static class ImageTransform {
        private String newFormat;
        private Integer newWidth;
        private Integer newHeight;
        private Integer oldWidth;
        private Integer oldHeight;
        private boolean preserveAspect = false;
        private boolean cropToFit = false;
        private boolean flatten = false;
        private Double quality;

        public ImageTransform(String newFormat, int newWidth, int newHeight, boolean preserveAspect, boolean cropToFit) {
            this(newFormat, newWidth, newHeight, 0, 0, preserveAspect, cropToFit);
        }

        public ImageTransform(String newFormat, int newWidth, int newHeight, int oldWidth, int oldHeight, boolean preserveAspect, boolean cropToFit) {
            this.newFormat = newFormat;
            this.newWidth = newWidth > 0 ? Integer.valueOf(newWidth) : null;
            this.oldWidth = oldWidth > 0 ? Integer.valueOf(oldWidth) : null;
            this.newHeight = newHeight > 0 ? Integer.valueOf(newHeight) : null;
            this.oldHeight = oldHeight > 0 ? Integer.valueOf(oldHeight) : null;
            this.preserveAspect = preserveAspect;
            this.cropToFit = cropToFit;
        }

        public ImageTransform(String newFormat, int newWidth, int newHeight, boolean preserveAspect, boolean cropToFit, boolean flatten) {
            this(newFormat, newWidth, newHeight, 0, 0, preserveAspect, cropToFit, flatten);
        }

        public ImageTransform(String newFormat, int newWidth, int newHeight, int oldWidth, int oldHeight, boolean preserveAspect, boolean cropToFit, boolean flatten) {
            this.newFormat = newFormat;
            this.newWidth = newWidth > 0 ? Integer.valueOf(newWidth) : null;
            this.oldWidth = oldWidth > 0 ? Integer.valueOf(oldWidth) : null;
            this.newHeight = newHeight > 0 ? Integer.valueOf(newHeight) : null;
            this.oldHeight = oldHeight > 0 ? Integer.valueOf(oldHeight) : null;
            this.preserveAspect = preserveAspect;
            this.cropToFit = cropToFit;
            this.flatten = flatten;
        }

        public String getNewFormat() {
            return this.newFormat;
        }

        public void setNewFormat(String newFormat) {
            this.newFormat = newFormat;
        }

        public Integer getOldWidth() {
            return this.oldWidth;
        }

        public void setOldWidth(Integer oldWidth) {
            this.oldWidth = oldWidth;
        }

        public Integer getOldHeight() {
            return this.oldHeight;
        }

        public void setOldHeight(Integer oldHeight) {
            this.oldHeight = oldHeight;
        }

        public Integer getNewWidth() {
            return this.newWidth;
        }

        public void setNewWidth(Integer newWidth) {
            this.newWidth = newWidth;
        }

        public Integer getNewHeight() {
            return this.newHeight;
        }

        public void setNewHeight(Integer newHeight) {
            this.newHeight = newHeight;
        }

        public boolean isPreserveAspect() {
            return this.preserveAspect;
        }

        public void setPreserveAspect(boolean preserveAspect) {
            this.preserveAspect = preserveAspect;
        }

        public boolean isCropToFit() {
            return this.cropToFit;
        }

        public void setCropToFit(boolean cropToFit) {
            this.cropToFit = cropToFit;
        }

        public boolean isFlatten() {
            return this.flatten;
        }

        public void setFlatten(boolean flatten) {
            this.flatten = flatten;
        }

        public Double getQuality() {
            return this.quality;
        }

        public void setQuality(Double quality) {
            this.quality = quality;
        }
    }

    public static class MagickParams {
        private byte[] imageFileData;
        private final boolean useGraphicsMagick;
        private File sourceFile;
        private File destFile;

        public MagickParams(byte[] imageFileData, boolean useGraphicsMagick) {
            this.imageFileData = (byte[])imageFileData.clone();
            this.useGraphicsMagick = useGraphicsMagick;
        }

        public MagickParams(byte[] imageFileData, File destFile, boolean useGraphicsMagick) {
            this(imageFileData, useGraphicsMagick);
            this.destFile = destFile;
        }

        public MagickParams(File sourceFile, File destFile, boolean useGraphicsMagick) {
            this.sourceFile = sourceFile;
            this.destFile = destFile;
            this.useGraphicsMagick = useGraphicsMagick;
        }

        public MagickParams(File sourceFile, boolean useGraphicsMagick) {
            this.sourceFile = sourceFile;
            this.useGraphicsMagick = useGraphicsMagick;
        }

        public byte[] getImageFileData() {
            return (byte[])this.imageFileData.clone();
        }

        public boolean usesGraphicsMagick() {
            return this.useGraphicsMagick;
        }

        public File getSourceFile() {
            return this.sourceFile;
        }

        public File getDestFile() {
            return this.destFile;
        }
    }
}

